% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellmapr.R
\name{load}
\alias{load}
\title{Load a microplate layout from a TOML file.}
\usage{
load(
  toml_path,
  data_loader = NULL,
  merge_cols = NULL,
  path_guess = NULL,
  path_required = FALSE,
  extras = NULL,
  report_dependencies = FALSE,
  on_alert = NULL
)
}
\arguments{
\item{toml_path}{The path to a file describing the layout of one or more plates.  See the
\href{https://wellmap.readthedocs.io/en/latest/file_format.html}{file format documentation}
for details about this file.}

\item{data_loader}{Indicates that \code{load()} should attempt to load the actual data associated
with the plate layout, in addition to loading the layout itself.  The
argument should be a function that takes a path to a data file (string),
parses it, and returns a data frame containing the parsed data.  The
function may also take an argument named "extras", in which case the
\code{extras} return value (described below) will be provided.  Note that
specifying a data loader implies that \code{path_required} is True.}

\item{merge_cols}{Indicates that \code{load()} should attempt to merge the plate layout and the
actual data associated with it into a single data frame.  This functionality
requires several conditions to be met:
\enumerate{
\item The \code{data_loader} argument must be specified (otherwise there'd be no
data to merge).
\item The data frame returned by \code{data_loader()} must be
\href{http://vita.had.co.nz/papers/tidy-data.html}{tidy}.
Briefly, a data frame is tidy if each of its columns represents a single
variable (e.g. time, fluorescence) and each of its rows represents a
single observation.
\item The data frame returned by \code{data_loader()} must have one (or more)
columns/variables indicating which well each row/observation comes from.
For example, a column called "Well" with values like "A1", "A2", "B1",
"B2", etc. would satisfy this requirement.
}

The \code{merge_cols} argument specifies which columns to use when merging the
data frames representing the layout and the actual data (i.e. the two data
frames that would be returned if \code{data_loader} was specified but
\code{merge_cols} was not) into one.  The argument can either be NULL, TRUE, or a
named list:

If \emph{NULL}, the data frames will be returned separately and not be merged.
This is the default behavior.

If \emph{TRUE}, the data frames will be merged using any columns that share the
same name.  For example, the layout will always have a column named \emph{well},
so if the actual data also has a column named \emph{well}, the merge would happen
on those columns.

If a named list, the keys and values identify the names of the columns that
correspond with each other for the purpose of merging.  Each key should be
one of the columns from the data frame representing the layout loaded from
the TOML file.  This data frame has 8 columns which identify the wells:
\emph{plate}, \emph{path}, \emph{well}, \emph{well0}, \emph{row}, \emph{col}, \emph{row_i}, \emph{row_j}.  See the
"Returns" section below for more details on the differences between these
columns.  Note that the \emph{path} column is included in the merge automatically
and never has to be specified.  Each value should be one of the columns from
the data frame representing the actual data.  This data frame will have
whatever columns were created by \code{data_loader()}.

Note that the columns named in each key-value pair must contain values that
correspond exactly (i.e. not "A1" and "A01").  It is the responsibility of
\code{data_loader()} to ensure that this is possible.}

\item{path_guess}{Where to look for a data file if none is specified in the given TOML file.
In other words, this is the default value for
\href{https://wellmap.readthedocs.io/en/latest/file_format.html#meta-path}{meta.path}.
This path is interpreted relative to the TOML file itself (unless it's an
absolute path) and is formatted in python with a \code{pathlib.Path} object
representing said TOML file.  In code, that would be:
\code{path_guess.format(Path(toml_path))}.  A typical value would be something
like \code{'{0.stem}.csv'}.}

\item{path_required}{Indicates whether or not the given TOML file must reference one or more data
files.  It is an error if this condition is not met.  Data files found via
\code{path_guess} are acceptable for this purpose.}

\item{extras}{One or more keys to extract directly from the given TOML file.  Typically,
this would be used to get information pertaining to the whole analysis and
not any wells in particular (e.g. instruments used, preferred algorithms,
plotting parameters, etc.).  Either one key (string) or multiple keys (list)
can be specified.  \href{https://github.com/toml-lang/toml#keys}{Dotted keys} are
supported.  Specifying this argument causes the value(s) corresponding to
the given key(s) to be returned, see below.}

\item{report_dependencies}{If \emph{TRUE}, return a vector of all the TOML files that were read in the
process of loading the layout from the given \code{toml_path}.  See the
description of \code{dependencies} below for more details.  You can use this
information in analysis scripts (e.g. in conjunction with
\code{file.info()$mtime}) to avoid repeating expensive analyses if the underlying
layout hasn't changed.}

\item{on_alert}{A callback to invoke if the given TOML file contains a warning for the user.
The default behavior is to print the warning to the terminal.  If a callback
is provided, it must take two arguments: the path to to the TOML file
containing the alert (string), and the message itself (string).  Note that
this could be called more than once, e.g. if there are included or
concatenated files.}
}
\value{
If neither \code{data_loader} nor \code{merge_cols} were provided:
\itemize{
\item \code{layout} (data frame): Information about the plate layout parsed from the
given TOML file.  The data frame will have a row for each well and a
column for each experimental condition.  In addition, there will be
several columns identifying each well:
\itemize{
\item \emph{plate}: The name of the plate for this well.  This column will not be
present if there are no \verb{[plate]} blocks in the TOML file.
\item \emph{path}: The path to the data file associated with the plate for this
well.  This column will not be present if no data files were referenced
by the TOML file.
\item \emph{well}: The name of the well, e.g. "A1".
\item \emph{well0}: The zero-padded name of the well, e.g. "A01".
\item \emph{row}: The name of the row for this well, e.g. "A".
\item \emph{col}: The name of the column for this well, e.g. "1".
\item \emph{row_i}: The row-index of this well, counting from 0.
\item \emph{col_j}: The column-index of this well, counting from 0.
}
}

If \code{data_loader} was provided but \code{merge_cols} was not:
\itemize{
\item \code{layout} (data frame): See above.
\item \code{data} (data frame): The concatenated result of calling \code{data_loader()} on
every path specified in the given TOML file.  See
\href{https://pandas.pydata.org/pandas-docs/stable/reference/api/pandas.concat.html}{\code{pandas.concat()}}
for more information on how the data from different paths are
concatenated.
}

If \code{data_loader} and \code{merge_cols} were both provided:
\itemize{
\item \code{merged} (data frame): The result of merging the \code{layout} and \code{data} data
frames along the columns specified by \code{merge_cols}.  See
\href{https://pandas.pydata.org/pandas-docs/stable/reference/api/pandas.merge.html}{\code{pandas.merge()}}
for more details on the merge itself.  The resulting data frame will have
one or more rows for each well (more are possible if there are multiple
data points per well, e.g. a time course), a column for each experimental
condition described in the TOML file, and a column for each kind of data
loaded from the data files.
}

If \code{extras} was provided:
\itemize{
\item \code{extras}: The value(s) corresponding to the specified "extra" key(s).  If
only one extra key was specified, only that value will be returned.  If
multiple extra keys were specified, a named list containing the value for
each such key will be returned.  For example, consider the following TOML
file:\preformatted{a = 1
b = 2
}

If we were to load this file with \code{extras='a'}, this return value would
simply be \code{1}.  With \verb{extras=['a', 'b']}, the same return value would
be \code{list(a=1, b=2)} instead.
}

If \code{report_dependencies} was provided:
\itemize{
\item \code{dependencies}: A vector of absolute paths to every layout file that was
referenced by \code{toml_path}.  This includes \code{toml_path} itself, and the
paths to any
\href{https://wellmap.readthedocs.io/en/latest/file_format.html#meta-include}{included}
or
\href{https://wellmap.readthedocs.io/en/latest/file_format.html#meta-concat}{concatenated}
layout files.  It does not include paths to \href{https://wellmap.readthedocs.io/en/latest/file_format.html#meta-path}{data files},
as these are included already in the \emph{path} column of the \code{layout} or
\code{merged} data frames.
}
}
\description{
Parse the given TOML file and return a data frame with a row for each well
and a column for each experimental condition specified in that file.  If the
'data_loader' and 'merge_cols' arguments are provided (which is the most
typical use-case), that data frame will also contain columns for any data
associated with each well.
}
