# -*- coding: utf-8 -*-
RESERVED_WORDS = [
    'aes128',
    'aes256',
    'all',
    'allowoverwrite',
    'analyse',
    'analyze',
    'and',
    'any',
    'array',
    'as',
    'asc',
    'authorization',
    'backup',
    'between',
    'binary',
    'blanksasnull',
    'both',
    'bytedict',
    'bzip2',
    'case',
    'cast',
    'check',
    'collate',
    'column',
    'constraint',
    'create',
    'credentials',
    'cross',
    'current_date',
    'current_time',
    'current_timestamp',
    'current_user',
    'current_user_id',
    'default',
    'deferrable',
    'deflate',
    'defrag',
    'delta',
    'delta32k',
    'desc',
    'disable',
    'distinct',
    'do',
    'else',
    'emptyasnull',
    'enable',
    'encode',
    'encrypt     ',
    'encryption',
    'end',
    'except',
    'explicit',
    'false',
    'for',
    'foreign',
    'freeze',
    'from',
    'full',
    'globaldict256',
    'globaldict64k',
    'grant',
    'group',
    'gzip',
    'having',
    'identity',
    'ignore',
    'ilike',
    'in',
    'initially',
    'inner',
    'intersect',
    'into',
    'is',
    'isnull',
    'join',
    'leading',
    'left',
    'like',
    'limit',
    'localtime',
    'localtimestamp',
    'lun',
    'luns',
    'lzo',
    'lzop',
    'minus',
    'mostly13',
    'mostly32',
    'mostly8',
    'natural',
    'new',
    'not',
    'notnull',
    'null',
    'nulls',
    'off',
    'offline',
    'offset',
    'oid',
    'old',
    'on',
    'only',
    'open',
    'or',
    'order',
    'outer',
    'overlaps',
    'parallel',
    'partition',
    'percent',
    'permissions',
    'placing',
    'primary',
    'raw',
    'readratio',
    'recover',
    'references',
    'respect',
    'rejectlog',
    'resort',
    'restore',
    'right',
    'select',
    'session_user',
    'similar',
    'snapshot ',
    'some',
    'sysdate',
    'system',
    'table',
    'tag',
    'tdes',
    'text255',
    'text32k',
    'then',
    'timestamp',
    'to',
    'top',
    'trailing',
    'true',
    'truncatecolumns',
    'union',
    'unique',
    'user',
    'using',
    'verbose',
    'wallet',
    'when',
    'where',
    'with',
    'without',
]

TOCSV_KWARGS = [
    'path_or_buf',
    'sep',
    'na_rep',
    'float_format',
    'columns',
    'header',
    'index',
    'index_label',
    'mode',
    'encoding',
    'compression',
    'quoting',
    'quotechar',
    'line_terminator',
    'chunksize',
    'tupleize_cols',
    'date_format',
    'doublequote',
    'escapechar',
    'decimal',
]

READ_TABLE_KWARGS = [
    'sep',
    'delimiter',
    'header',
    'names',
    'index_col',
    'usecols',
    'squeeze',
    'prefix',
    'mangle_dupe_cols',
    'dtype',
    'engine',
    'converters',
    'true_values',
    'false_values',
    'skipinitialspace',
    'skiprows',
    'nrows',
    'na_values',
    'keep_default_na',
    'na_filter',
    'verbose',
    'skip_blank_lines',
    'parse_dates',
    'infer_datetime_format',
    'keep_date_col',
    'date_parser',
    'dayfirst',
    'iterator',
    'chunksize',
    'compression',
    'thousands',
    'decimal',
    'lineterminator',
    'quotechar',
    'quoting',
    'escapechar',
    'comment',
    'encoding',
    'dialect',
    'tupleize_cols',
    'error_bad_lines',
    'warn_bad_lines',
    'skipfooter',
    'doublequote',
    'delim_whitespace',
    'low_memory',
    'memory_map',
    'float_precision',
]

COPY_KWARGS = [
    'delimiter',
    'ignoreheader',
    'quote_character',
    'dateformat',
    'timeformat',
    'region',
    'null',
    'escape',  # bool
    'acceptinvchars',  # str
    'iam_role',
    'acceptanydate',  # bool
    'column_list',  # list[str]
    'blanksasnull',  # bool
    'emptyasnull',  # bool
    'encoding',  # str
    'explicit_ids',  # bool
    'fillrecord',  # bool
    'ignoreblanklines',  # bool
    'removequotes',  # bool
    'roundec',  # bool
    'trimblanks',  # bool
    'truncatecolumns',  # bool
]

UNLOAD_KWARGS = [
    'manifest',  # bool
    'delimiter',
    'fixedwidth',
    'encrypted',  # bool
    'bzip2',  # bool
    'gzip',  # bool
    'addquotes',  # bool
    'null',
    'escap',  # bool
    'allowoverwrite',  # bool
    'parallel',
    'maxfilesize',
]

S3_PUT_KWARGS = [
    'ACL',
    # 'Body', required in our context and handled seperately
    'CacheControl',
    'ContentDisposition',
    'ContentEncoding',
    'ContentLanguage',
    'ContentLength',
    'ContentMD5',
    'ContentType',
    'Expires',
    'GrantFullControl',
    'GrantRead',
    'GrantReadACP',
    'GrantWriteACP',
    # 'Key', required and handled seperately
    'Metadata',
    'ServerSideEncryption',
    'StorageClass',
    'WebsiteRedirectLocation',
    'SSECustomerAlgorithm',
    'SSECustomerKey',
    'SSEKMSKeyId',
    'RequestPayer',
    'Tagging',
]

S3_GET_KWARGS = [
    'Bucket',
    'IfMatch',
    'IfModifiedSince',
    'IfNoneMatch',
    'IfUnmodifiedSince',
    'Key',
    'Range',
    'ResponseCacheControl',
    'ResponseContentDisposition',
    'ResponseContentEncoding',
    'ResponseContentLanguage',
    'ResponseContentType',
    'ResponseExpires',
    'VersionId',
    'SSECustomerAlgorithm',
    'SSECustomerKey',
    'RequestPayer',
    'PartNumber',
]

S3_CREATE_BUCKET_KWARGS = [
    'ACL',
    'CreateBucketConfiguration',
    'GrantFullControl',
    'GrantRead',
    'GrantReadACP',
    'GrantWrite',
    'GrantWriteACP',
]

TYPES_MAP = {
    'O': 'varchar(256)',
    'object': 'varchar(256)',
    'int64': 'bigint',
    'float64': 'double precision',
}

AWSCLI_CREATE_CLUSTER_ARGS = [
    'auto-terminate',
    'no-auto-terminate',
    'use-default-roles',
    'termination-protected',
    'no-termination-protected',
    'visible-to-all-users',
    'no-visible-to-all-users',
    'enable-debugging',
    'no-enable-debugging',
]

AWSCLI_CREATE_CLUSTER_KWARGS = [
    'release-label',
    'ami-version',
    'instance-fleets',
    'instance-groups',
    'instance-type',
    'instance-count',
    'service-role',
    'configurations',
    'name',
    'log-uri',
    'additional-info',
    'ec2-attributes',
    'scale-down-behavior',
    'tags',
    'applications',
    'emrfs',
    'bootstrap-actions',
    'steps',
    'restore-from-hbase-backup',
    'security-configuration',
    'custom-ami-id',
    'ebs-root-volume-size',
    'repo-upgrade-on-boot',
    'kerberos-attributes',
]
