#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.user import UserFragment, QUERY as UserFragmentQuery


# fmt: off
QUERY: List[str] = UserFragmentQuery + ["""
query UserQuery($authID: String!) {
  user(authID: $authID) {
    ...UserFragment
  }
}

"""
]


class UserQuery:
    @dataclass(frozen=True)
    class UserQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class User(UserFragment):
            pass

        user: Optional[User]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, authID: str) -> Optional[UserQueryData.User]:
        variables: Dict[str, Any] = {"authID": authID}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.UserQueryData.from_dict(response_text)
        return res.user

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, authID: str) -> Optional[UserQueryData.User]:
        variables: Dict[str, Any] = {"authID": authID}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.UserQueryData.from_dict(response_text)
        return res.user
