#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.recommendations_filter_input import RecommendationsFilterInput
from ..input.recommendations_order import RecommendationsOrder


# fmt: off
QUERY: List[str] = ["""
query Recommendations(
$after: Cursor
$first: Int
$before: Cursor
$last: Int
$orderBy: RecommendationsOrder
$filterBy: [RecommendationsFilterInput!]
){
Recommendations(after: $after, first: $first, before: $before, last: $last, orderBy: $orderBy, filterBy: $filterBy){
totalCount
edges{
node{
    id
    externalID
    resource
    alarmType
    shortDescription
    longDescription
    command
    runbook
    priority
    status
    used
    vendor{id}
    recommendationsSources{id}
    recommendationsCategory{id}
    userCreate{
      name
      id}
    userApprobed{
      name
      id}

}
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}

"""
]


class Recommendations:
    @dataclass(frozen=True)
    class RecommendationsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class RecommendationsConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class RecommendationsEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Recommendations(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class Vendor(DataClassJsonMixin):
                        id: str

                    @dataclass(frozen=True)
                    class RecommendationsSources(DataClassJsonMixin):
                        id: str

                    @dataclass(frozen=True)
                    class RecommendationsCategory(DataClassJsonMixin):
                        id: str

                    @dataclass(frozen=True)
                    class User(DataClassJsonMixin):
                        name: str
                        id: str

                    id: str
                    externalID: str
                    resource: str
                    alarmType: str
                    shortDescription: str
                    longDescription: str
                    command: Optional[str]
                    runbook: Optional[str]
                    priority: int
                    status: bool
                    used: Optional[int]
                    vendor: Vendor
                    recommendationsSources: RecommendationsSources
                    recommendationsCategory: RecommendationsCategory
                    userCreate: User
                    userApprobed: Optional[User]

                node: Optional[Recommendations]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[RecommendationsEdge]
            pageInfo: PageInfo

        Recommendations: RecommendationsConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[RecommendationsOrder] = None, filterBy: List[RecommendationsFilterInput] = []) -> RecommendationsData.RecommendationsConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.RecommendationsData.from_dict(response_text)
        return res.Recommendations

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[RecommendationsOrder] = None, filterBy: List[RecommendationsFilterInput] = []) -> RecommendationsData.RecommendationsConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.RecommendationsData.from_dict(response_text)
        return res.Recommendations
