#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.equipment import EquipmentFragment, QUERY as EquipmentFragmentQuery

from ..fragment.page_info import PageInfoFragment, QUERY as PageInfoFragmentQuery


# fmt: off
QUERY: List[str] = EquipmentFragmentQuery + PageInfoFragmentQuery + ["""
query EquipmentsQuery($after: Cursor, $first: Int) {
  equipments(after: $after, first: $first) {
    edges {
      node {
        ...EquipmentFragment
      }
    }
    pageInfo {
      ...PageInfoFragment
    }
  }
}

"""
]


class EquipmentsQuery:
    @dataclass(frozen=True)
    class EquipmentsQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class EquipmentConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class EquipmentEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Equipment(EquipmentFragment):
                    pass

                node: Optional[Equipment]

            @dataclass(frozen=True)
            class PageInfo(PageInfoFragment):
                pass

            edges: List[EquipmentEdge]
            pageInfo: PageInfo

        equipments: EquipmentConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None) -> EquipmentsQueryData.EquipmentConnection:
        variables: Dict[str, Any] = {"after": after, "first": first}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.EquipmentsQueryData.from_dict(response_text)
        return res.equipments

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None) -> EquipmentsQueryData.EquipmentConnection:
        variables: Dict[str, Any] = {"after": after, "first": first}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.EquipmentsQueryData.from_dict(response_text)
        return res.equipments
