#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.location import LocationFragment, QUERY as LocationFragmentQuery


# fmt: off
QUERY: List[str] = LocationFragmentQuery + ["""
mutation MoveLocationMutation($locationID: ID!, $parentLocationID: ID) {
  moveLocation(locationID: $locationID, parentLocationID: $parentLocationID) {
    ...LocationFragment
  }
}

"""
]


class MoveLocationMutation:
    @dataclass(frozen=True)
    class MoveLocationMutationData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Location(LocationFragment):
            pass

        moveLocation: Location

    # fmt: off
    @classmethod
    def execute(cls, client: Client, locationID: str, parentLocationID: Optional[str] = None) -> MoveLocationMutationData.Location:
        variables: Dict[str, Any] = {"locationID": locationID, "parentLocationID": parentLocationID}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.MoveLocationMutationData.from_dict(response_text)
        return res.moveLocation

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, locationID: str, parentLocationID: Optional[str] = None) -> MoveLocationMutationData.Location:
        variables: Dict[str, Any] = {"locationID": locationID, "parentLocationID": parentLocationID}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.MoveLocationMutationData.from_dict(response_text)
        return res.moveLocation
