#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.edit_formula_input import EditFormulaInput


# fmt: off
QUERY: List[str] = ["""
mutation editFormula($input: EditFormulaInput!) {
  editFormula(input: $input) {
    id
    textFormula
    techFk{id}
    kpiFk{id}
    networkTypeFk{id}
    status
  }
}

"""
]


class editFormula:
    @dataclass(frozen=True)
    class editFormulaData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Formula(DataClassJsonMixin):
            @dataclass(frozen=True)
            class Tech(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class Kpi(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class NetworkType(DataClassJsonMixin):
                id: str

            id: str
            textFormula: str
            techFk: Tech
            kpiFk: Kpi
            networkTypeFk: NetworkType
            status: bool

        editFormula: Formula

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: EditFormulaInput) -> editFormulaData.Formula:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editFormulaData.from_dict(response_text)
        return res.editFormula

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: EditFormulaInput) -> editFormulaData.Formula:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editFormulaData.from_dict(response_text)
        return res.editFormula
