#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.edit_counter_input import EditCounterInput


# fmt: off
QUERY: List[str] = ["""
mutation editCounter($input: EditCounterInput!) {
  editCounter(input: $input) {
    id
    name
    externalID
    networkManagerSystem
    vendorFk{id}
    counterFamily{id}
  }
}

"""
]


class editCounter:
    @dataclass(frozen=True)
    class editCounterData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Counter(DataClassJsonMixin):
            @dataclass(frozen=True)
            class Vendor(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class CounterFamily(DataClassJsonMixin):
                id: str

            id: str
            name: str
            externalID: str
            networkManagerSystem: str
            vendorFk: Vendor
            counterFamily: Optional[CounterFamily]

        editCounter: Counter

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: EditCounterInput) -> editCounterData.Counter:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editCounterData.from_dict(response_text)
        return res.editCounter

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: EditCounterInput) -> editCounterData.Counter:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editCounterData.from_dict(response_text)
        return res.editCounter
