import requests, xlrd

from ..base import Base


class MalwareArchaeology(Base):
    """
    Data Source: https://github.com/MalwareArchaeology/ATTACK
    Author:  Hacker Hurricane

    This class is a wrapper for the above data set
    """

    WIN_EVENTS_URL = 'https://raw.githubusercontent.com/MalwareArchaeology/ATTACK/master/Windows_Logging_Attack_Matrix_Win_Events_Sept_2018.xlsx'
    SYSMON_EVENTS_URL = 'https://raw.githubusercontent.com/MalwareArchaeology/ATTACK/master/Windows_Logging_Sysmon_LOG-MD_Attack_Matrix_Sept_2018.xlsx'

    OFFSET = 4
    
    def _parse(self, sheet):
        columns = []
        for item in sheet.__dict__['_cell_values'][self.OFFSET]:
            if item:
                columns.append(item.replace('\n',''))
        self.OFFSET += 1

        count = len(sheet.__dict__['_cell_values'])

        while self.OFFSET != count:
            skip = True
            row_list = []
            for item in sheet.__dict__['_cell_values'][self.OFFSET]:
                if skip:
                    skip = False
                    continue
                row_list.append(item)
            data_dict = dict(zip(columns, row_list))
            for key,val in data_dict.items():
                if 'Data Source' in key:
                    if val:
                        name_list = []
                        for item in str(val).splitlines():
                            for id in item.split(','):
                                name_list.append(id)
                        self.generated_data.add_possible_detection(
                            technique_id=data_dict["TechniqueID"],
                            data=name_list
                        )
            self.OFFSET += 1

    def get(self):
        response = requests.get(self.WIN_EVENTS_URL)
        workbook = xlrd.open_workbook(file_contents=response.content)  # open workbook
        worksheet = workbook.sheet_by_index(0)  # get first sheet
        self._parse(worksheet)

        self.OFFSET = 4
        response = requests.get(self.SYSMON_EVENTS_URL)
        workbook = xlrd.open_workbook(file_contents=response.content)  # open workbook
        worksheet = workbook.sheet_by_index(0)  # get first sheet
        self._parse(worksheet)
