"""
Type annotations for chime-sdk-media-pipelines service type definitions.

[Open documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_media_pipelines/type_defs/)

Usage::

    ```python
    from mypy_boto3_chime_sdk_media_pipelines.type_defs import ActiveSpeakerOnlyConfigurationTypeDef

    data: ActiveSpeakerOnlyConfigurationTypeDef = ...
    ```
"""
import sys
from datetime import datetime
from typing import Dict, List, Mapping, Sequence, Union

from .literals import (
    ActiveSpeakerPositionType,
    ArtifactsConcatenationStateType,
    ArtifactsStateType,
    AudioChannelsOptionType,
    AudioMuxTypeType,
    BorderColorType,
    CallAnalyticsLanguageCodeType,
    CanvasOrientationType,
    ContentRedactionOutputType,
    ContentShareLayoutOptionType,
    FragmentSelectorTypeType,
    HighlightColorType,
    HorizontalTilePositionType,
    LiveConnectorMuxTypeType,
    MediaInsightsPipelineConfigurationElementTypeType,
    MediaPipelineStatusType,
    MediaPipelineStatusUpdateType,
    PartialResultsStabilityType,
    ParticipantRoleType,
    PresenterPositionType,
    RealTimeAlertRuleTypeType,
    RecordingFileFormatType,
    ResolutionOptionType,
    TileOrderType,
    VerticalTilePositionType,
    VocabularyFilterMethodType,
    VoiceAnalyticsConfigurationStatusType,
)

if sys.version_info >= (3, 12):
    from typing import Literal
else:
    from typing_extensions import Literal
if sys.version_info >= (3, 12):
    from typing import NotRequired
else:
    from typing_extensions import NotRequired
if sys.version_info >= (3, 12):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


__all__ = (
    "ActiveSpeakerOnlyConfigurationTypeDef",
    "PostCallAnalyticsSettingsTypeDef",
    "AmazonTranscribeProcessorConfigurationTypeDef",
    "AudioConcatenationConfigurationTypeDef",
    "CompositedVideoConcatenationConfigurationTypeDef",
    "ContentConcatenationConfigurationTypeDef",
    "DataChannelConcatenationConfigurationTypeDef",
    "MeetingEventsConcatenationConfigurationTypeDef",
    "TranscriptionMessagesConcatenationConfigurationTypeDef",
    "VideoConcatenationConfigurationTypeDef",
    "AudioArtifactsConfigurationTypeDef",
    "ContentArtifactsConfigurationTypeDef",
    "VideoArtifactsConfigurationTypeDef",
    "ChannelDefinitionTypeDef",
    "S3BucketSinkConfigurationTypeDef",
    "TagTypeDef",
    "ResponseMetadataTypeDef",
    "S3RecordingSinkRuntimeConfigurationTypeDef",
    "DeleteMediaCapturePipelineRequestRequestTypeDef",
    "DeleteMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    "DeleteMediaPipelineRequestRequestTypeDef",
    "GetMediaCapturePipelineRequestRequestTypeDef",
    "GetMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    "GetMediaPipelineRequestRequestTypeDef",
    "HorizontalLayoutConfigurationTypeDef",
    "PresenterOnlyConfigurationTypeDef",
    "VerticalLayoutConfigurationTypeDef",
    "VideoAttributeTypeDef",
    "IssueDetectionConfigurationTypeDef",
    "KeywordMatchConfigurationTypeDef",
    "KinesisDataStreamSinkConfigurationTypeDef",
    "RecordingStreamConfigurationTypeDef",
    "LambdaFunctionSinkConfigurationTypeDef",
    "ListMediaCapturePipelinesRequestRequestTypeDef",
    "MediaCapturePipelineSummaryTypeDef",
    "ListMediaInsightsPipelineConfigurationsRequestRequestTypeDef",
    "MediaInsightsPipelineConfigurationSummaryTypeDef",
    "ListMediaPipelinesRequestRequestTypeDef",
    "MediaPipelineSummaryTypeDef",
    "ListTagsForResourceRequestRequestTypeDef",
    "LiveConnectorRTMPConfigurationTypeDef",
    "S3RecordingSinkConfigurationTypeDef",
    "SnsTopicSinkConfigurationTypeDef",
    "SqsQueueSinkConfigurationTypeDef",
    "VoiceAnalyticsProcessorConfigurationTypeDef",
    "SentimentConfigurationTypeDef",
    "SelectedVideoStreamsTypeDef",
    "TimestampTypeDef",
    "UntagResourceRequestRequestTypeDef",
    "UpdateMediaInsightsPipelineStatusRequestRequestTypeDef",
    "AmazonTranscribeCallAnalyticsProcessorConfigurationTypeDef",
    "ArtifactsConcatenationConfigurationTypeDef",
    "StreamChannelDefinitionTypeDef",
    "ConcatenationSinkTypeDef",
    "TagResourceRequestRequestTypeDef",
    "EmptyResponseMetadataTypeDef",
    "ListTagsForResourceResponseTypeDef",
    "GridViewConfigurationTypeDef",
    "ListMediaCapturePipelinesResponseTypeDef",
    "ListMediaInsightsPipelineConfigurationsResponseTypeDef",
    "ListMediaPipelinesResponseTypeDef",
    "LiveConnectorSinkConfigurationTypeDef",
    "RealTimeAlertRuleTypeDef",
    "SourceConfigurationTypeDef",
    "TimestampRangeTypeDef",
    "MediaInsightsPipelineConfigurationElementTypeDef",
    "ChimeSdkMeetingConcatenationConfigurationTypeDef",
    "StreamConfigurationTypeDef",
    "CompositedVideoArtifactsConfigurationTypeDef",
    "RealTimeAlertConfigurationTypeDef",
    "FragmentSelectorTypeDef",
    "MediaCapturePipelineSourceConfigurationTypeDef",
    "KinesisVideoStreamSourceRuntimeConfigurationTypeDef",
    "ArtifactsConfigurationTypeDef",
    "ChimeSdkMeetingLiveConnectorConfigurationTypeDef",
    "CreateMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    "MediaInsightsPipelineConfigurationTypeDef",
    "UpdateMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    "KinesisVideoStreamRecordingSourceRuntimeConfigurationTypeDef",
    "ConcatenationSourceTypeDef",
    "ChimeSdkMeetingConfigurationTypeDef",
    "LiveConnectorSourceConfigurationTypeDef",
    "CreateMediaInsightsPipelineConfigurationResponseTypeDef",
    "GetMediaInsightsPipelineConfigurationResponseTypeDef",
    "UpdateMediaInsightsPipelineConfigurationResponseTypeDef",
    "CreateMediaInsightsPipelineRequestRequestTypeDef",
    "MediaInsightsPipelineTypeDef",
    "CreateMediaConcatenationPipelineRequestRequestTypeDef",
    "MediaConcatenationPipelineTypeDef",
    "CreateMediaCapturePipelineRequestRequestTypeDef",
    "MediaCapturePipelineTypeDef",
    "CreateMediaLiveConnectorPipelineRequestRequestTypeDef",
    "MediaLiveConnectorPipelineTypeDef",
    "CreateMediaInsightsPipelineResponseTypeDef",
    "CreateMediaConcatenationPipelineResponseTypeDef",
    "CreateMediaCapturePipelineResponseTypeDef",
    "GetMediaCapturePipelineResponseTypeDef",
    "CreateMediaLiveConnectorPipelineResponseTypeDef",
    "MediaPipelineTypeDef",
    "GetMediaPipelineResponseTypeDef",
)

ActiveSpeakerOnlyConfigurationTypeDef = TypedDict(
    "ActiveSpeakerOnlyConfigurationTypeDef",
    {
        "ActiveSpeakerPosition": NotRequired[ActiveSpeakerPositionType],
    },
)

PostCallAnalyticsSettingsTypeDef = TypedDict(
    "PostCallAnalyticsSettingsTypeDef",
    {
        "OutputLocation": str,
        "DataAccessRoleArn": str,
        "ContentRedactionOutput": NotRequired[ContentRedactionOutputType],
        "OutputEncryptionKMSKeyId": NotRequired[str],
    },
)

AmazonTranscribeProcessorConfigurationTypeDef = TypedDict(
    "AmazonTranscribeProcessorConfigurationTypeDef",
    {
        "LanguageCode": NotRequired[CallAnalyticsLanguageCodeType],
        "VocabularyName": NotRequired[str],
        "VocabularyFilterName": NotRequired[str],
        "VocabularyFilterMethod": NotRequired[VocabularyFilterMethodType],
        "ShowSpeakerLabel": NotRequired[bool],
        "EnablePartialResultsStabilization": NotRequired[bool],
        "PartialResultsStability": NotRequired[PartialResultsStabilityType],
        "ContentIdentificationType": NotRequired[Literal["PII"]],
        "ContentRedactionType": NotRequired[Literal["PII"]],
        "PiiEntityTypes": NotRequired[str],
        "LanguageModelName": NotRequired[str],
        "FilterPartialResults": NotRequired[bool],
        "IdentifyLanguage": NotRequired[bool],
        "LanguageOptions": NotRequired[str],
        "PreferredLanguage": NotRequired[CallAnalyticsLanguageCodeType],
        "VocabularyNames": NotRequired[str],
        "VocabularyFilterNames": NotRequired[str],
    },
)

AudioConcatenationConfigurationTypeDef = TypedDict(
    "AudioConcatenationConfigurationTypeDef",
    {
        "State": Literal["Enabled"],
    },
)

CompositedVideoConcatenationConfigurationTypeDef = TypedDict(
    "CompositedVideoConcatenationConfigurationTypeDef",
    {
        "State": ArtifactsConcatenationStateType,
    },
)

ContentConcatenationConfigurationTypeDef = TypedDict(
    "ContentConcatenationConfigurationTypeDef",
    {
        "State": ArtifactsConcatenationStateType,
    },
)

DataChannelConcatenationConfigurationTypeDef = TypedDict(
    "DataChannelConcatenationConfigurationTypeDef",
    {
        "State": ArtifactsConcatenationStateType,
    },
)

MeetingEventsConcatenationConfigurationTypeDef = TypedDict(
    "MeetingEventsConcatenationConfigurationTypeDef",
    {
        "State": ArtifactsConcatenationStateType,
    },
)

TranscriptionMessagesConcatenationConfigurationTypeDef = TypedDict(
    "TranscriptionMessagesConcatenationConfigurationTypeDef",
    {
        "State": ArtifactsConcatenationStateType,
    },
)

VideoConcatenationConfigurationTypeDef = TypedDict(
    "VideoConcatenationConfigurationTypeDef",
    {
        "State": ArtifactsConcatenationStateType,
    },
)

AudioArtifactsConfigurationTypeDef = TypedDict(
    "AudioArtifactsConfigurationTypeDef",
    {
        "MuxType": AudioMuxTypeType,
    },
)

ContentArtifactsConfigurationTypeDef = TypedDict(
    "ContentArtifactsConfigurationTypeDef",
    {
        "State": ArtifactsStateType,
        "MuxType": NotRequired[Literal["ContentOnly"]],
    },
)

VideoArtifactsConfigurationTypeDef = TypedDict(
    "VideoArtifactsConfigurationTypeDef",
    {
        "State": ArtifactsStateType,
        "MuxType": NotRequired[Literal["VideoOnly"]],
    },
)

ChannelDefinitionTypeDef = TypedDict(
    "ChannelDefinitionTypeDef",
    {
        "ChannelId": int,
        "ParticipantRole": NotRequired[ParticipantRoleType],
    },
)

S3BucketSinkConfigurationTypeDef = TypedDict(
    "S3BucketSinkConfigurationTypeDef",
    {
        "Destination": str,
    },
)

TagTypeDef = TypedDict(
    "TagTypeDef",
    {
        "Key": str,
        "Value": str,
    },
)

ResponseMetadataTypeDef = TypedDict(
    "ResponseMetadataTypeDef",
    {
        "RequestId": str,
        "HostId": str,
        "HTTPStatusCode": int,
        "HTTPHeaders": Dict[str, str],
        "RetryAttempts": int,
    },
)

S3RecordingSinkRuntimeConfigurationTypeDef = TypedDict(
    "S3RecordingSinkRuntimeConfigurationTypeDef",
    {
        "Destination": str,
        "RecordingFileFormat": RecordingFileFormatType,
    },
)

DeleteMediaCapturePipelineRequestRequestTypeDef = TypedDict(
    "DeleteMediaCapturePipelineRequestRequestTypeDef",
    {
        "MediaPipelineId": str,
    },
)

DeleteMediaInsightsPipelineConfigurationRequestRequestTypeDef = TypedDict(
    "DeleteMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    {
        "Identifier": str,
    },
)

DeleteMediaPipelineRequestRequestTypeDef = TypedDict(
    "DeleteMediaPipelineRequestRequestTypeDef",
    {
        "MediaPipelineId": str,
    },
)

GetMediaCapturePipelineRequestRequestTypeDef = TypedDict(
    "GetMediaCapturePipelineRequestRequestTypeDef",
    {
        "MediaPipelineId": str,
    },
)

GetMediaInsightsPipelineConfigurationRequestRequestTypeDef = TypedDict(
    "GetMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    {
        "Identifier": str,
    },
)

GetMediaPipelineRequestRequestTypeDef = TypedDict(
    "GetMediaPipelineRequestRequestTypeDef",
    {
        "MediaPipelineId": str,
    },
)

HorizontalLayoutConfigurationTypeDef = TypedDict(
    "HorizontalLayoutConfigurationTypeDef",
    {
        "TileOrder": NotRequired[TileOrderType],
        "TilePosition": NotRequired[HorizontalTilePositionType],
        "TileCount": NotRequired[int],
        "TileAspectRatio": NotRequired[str],
    },
)

PresenterOnlyConfigurationTypeDef = TypedDict(
    "PresenterOnlyConfigurationTypeDef",
    {
        "PresenterPosition": NotRequired[PresenterPositionType],
    },
)

VerticalLayoutConfigurationTypeDef = TypedDict(
    "VerticalLayoutConfigurationTypeDef",
    {
        "TileOrder": NotRequired[TileOrderType],
        "TilePosition": NotRequired[VerticalTilePositionType],
        "TileCount": NotRequired[int],
        "TileAspectRatio": NotRequired[str],
    },
)

VideoAttributeTypeDef = TypedDict(
    "VideoAttributeTypeDef",
    {
        "CornerRadius": NotRequired[int],
        "BorderColor": NotRequired[BorderColorType],
        "HighlightColor": NotRequired[HighlightColorType],
        "BorderThickness": NotRequired[int],
    },
)

IssueDetectionConfigurationTypeDef = TypedDict(
    "IssueDetectionConfigurationTypeDef",
    {
        "RuleName": str,
    },
)

KeywordMatchConfigurationTypeDef = TypedDict(
    "KeywordMatchConfigurationTypeDef",
    {
        "RuleName": str,
        "Keywords": Sequence[str],
        "Negate": NotRequired[bool],
    },
)

KinesisDataStreamSinkConfigurationTypeDef = TypedDict(
    "KinesisDataStreamSinkConfigurationTypeDef",
    {
        "InsightsTarget": NotRequired[str],
    },
)

RecordingStreamConfigurationTypeDef = TypedDict(
    "RecordingStreamConfigurationTypeDef",
    {
        "StreamArn": NotRequired[str],
    },
)

LambdaFunctionSinkConfigurationTypeDef = TypedDict(
    "LambdaFunctionSinkConfigurationTypeDef",
    {
        "InsightsTarget": NotRequired[str],
    },
)

ListMediaCapturePipelinesRequestRequestTypeDef = TypedDict(
    "ListMediaCapturePipelinesRequestRequestTypeDef",
    {
        "NextToken": NotRequired[str],
        "MaxResults": NotRequired[int],
    },
)

MediaCapturePipelineSummaryTypeDef = TypedDict(
    "MediaCapturePipelineSummaryTypeDef",
    {
        "MediaPipelineId": NotRequired[str],
        "MediaPipelineArn": NotRequired[str],
    },
)

ListMediaInsightsPipelineConfigurationsRequestRequestTypeDef = TypedDict(
    "ListMediaInsightsPipelineConfigurationsRequestRequestTypeDef",
    {
        "NextToken": NotRequired[str],
        "MaxResults": NotRequired[int],
    },
)

MediaInsightsPipelineConfigurationSummaryTypeDef = TypedDict(
    "MediaInsightsPipelineConfigurationSummaryTypeDef",
    {
        "MediaInsightsPipelineConfigurationName": NotRequired[str],
        "MediaInsightsPipelineConfigurationId": NotRequired[str],
        "MediaInsightsPipelineConfigurationArn": NotRequired[str],
    },
)

ListMediaPipelinesRequestRequestTypeDef = TypedDict(
    "ListMediaPipelinesRequestRequestTypeDef",
    {
        "NextToken": NotRequired[str],
        "MaxResults": NotRequired[int],
    },
)

MediaPipelineSummaryTypeDef = TypedDict(
    "MediaPipelineSummaryTypeDef",
    {
        "MediaPipelineId": NotRequired[str],
        "MediaPipelineArn": NotRequired[str],
    },
)

ListTagsForResourceRequestRequestTypeDef = TypedDict(
    "ListTagsForResourceRequestRequestTypeDef",
    {
        "ResourceARN": str,
    },
)

LiveConnectorRTMPConfigurationTypeDef = TypedDict(
    "LiveConnectorRTMPConfigurationTypeDef",
    {
        "Url": str,
        "AudioChannels": NotRequired[AudioChannelsOptionType],
        "AudioSampleRate": NotRequired[str],
    },
)

S3RecordingSinkConfigurationTypeDef = TypedDict(
    "S3RecordingSinkConfigurationTypeDef",
    {
        "Destination": NotRequired[str],
        "RecordingFileFormat": NotRequired[RecordingFileFormatType],
    },
)

SnsTopicSinkConfigurationTypeDef = TypedDict(
    "SnsTopicSinkConfigurationTypeDef",
    {
        "InsightsTarget": NotRequired[str],
    },
)

SqsQueueSinkConfigurationTypeDef = TypedDict(
    "SqsQueueSinkConfigurationTypeDef",
    {
        "InsightsTarget": NotRequired[str],
    },
)

VoiceAnalyticsProcessorConfigurationTypeDef = TypedDict(
    "VoiceAnalyticsProcessorConfigurationTypeDef",
    {
        "SpeakerSearchStatus": NotRequired[VoiceAnalyticsConfigurationStatusType],
        "VoiceToneAnalysisStatus": NotRequired[VoiceAnalyticsConfigurationStatusType],
    },
)

SentimentConfigurationTypeDef = TypedDict(
    "SentimentConfigurationTypeDef",
    {
        "RuleName": str,
        "SentimentType": Literal["NEGATIVE"],
        "TimePeriod": int,
    },
)

SelectedVideoStreamsTypeDef = TypedDict(
    "SelectedVideoStreamsTypeDef",
    {
        "AttendeeIds": NotRequired[Sequence[str]],
        "ExternalUserIds": NotRequired[Sequence[str]],
    },
)

TimestampTypeDef = Union[datetime, str]
UntagResourceRequestRequestTypeDef = TypedDict(
    "UntagResourceRequestRequestTypeDef",
    {
        "ResourceARN": str,
        "TagKeys": Sequence[str],
    },
)

UpdateMediaInsightsPipelineStatusRequestRequestTypeDef = TypedDict(
    "UpdateMediaInsightsPipelineStatusRequestRequestTypeDef",
    {
        "Identifier": str,
        "UpdateStatus": MediaPipelineStatusUpdateType,
    },
)

AmazonTranscribeCallAnalyticsProcessorConfigurationTypeDef = TypedDict(
    "AmazonTranscribeCallAnalyticsProcessorConfigurationTypeDef",
    {
        "LanguageCode": CallAnalyticsLanguageCodeType,
        "VocabularyName": NotRequired[str],
        "VocabularyFilterName": NotRequired[str],
        "VocabularyFilterMethod": NotRequired[VocabularyFilterMethodType],
        "LanguageModelName": NotRequired[str],
        "EnablePartialResultsStabilization": NotRequired[bool],
        "PartialResultsStability": NotRequired[PartialResultsStabilityType],
        "ContentIdentificationType": NotRequired[Literal["PII"]],
        "ContentRedactionType": NotRequired[Literal["PII"]],
        "PiiEntityTypes": NotRequired[str],
        "FilterPartialResults": NotRequired[bool],
        "PostCallAnalyticsSettings": NotRequired[PostCallAnalyticsSettingsTypeDef],
        "CallAnalyticsStreamCategories": NotRequired[Sequence[str]],
    },
)

ArtifactsConcatenationConfigurationTypeDef = TypedDict(
    "ArtifactsConcatenationConfigurationTypeDef",
    {
        "Audio": AudioConcatenationConfigurationTypeDef,
        "Video": VideoConcatenationConfigurationTypeDef,
        "Content": ContentConcatenationConfigurationTypeDef,
        "DataChannel": DataChannelConcatenationConfigurationTypeDef,
        "TranscriptionMessages": TranscriptionMessagesConcatenationConfigurationTypeDef,
        "MeetingEvents": MeetingEventsConcatenationConfigurationTypeDef,
        "CompositedVideo": CompositedVideoConcatenationConfigurationTypeDef,
    },
)

StreamChannelDefinitionTypeDef = TypedDict(
    "StreamChannelDefinitionTypeDef",
    {
        "NumberOfChannels": int,
        "ChannelDefinitions": NotRequired[Sequence[ChannelDefinitionTypeDef]],
    },
)

ConcatenationSinkTypeDef = TypedDict(
    "ConcatenationSinkTypeDef",
    {
        "Type": Literal["S3Bucket"],
        "S3BucketSinkConfiguration": S3BucketSinkConfigurationTypeDef,
    },
)

TagResourceRequestRequestTypeDef = TypedDict(
    "TagResourceRequestRequestTypeDef",
    {
        "ResourceARN": str,
        "Tags": Sequence[TagTypeDef],
    },
)

EmptyResponseMetadataTypeDef = TypedDict(
    "EmptyResponseMetadataTypeDef",
    {
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

ListTagsForResourceResponseTypeDef = TypedDict(
    "ListTagsForResourceResponseTypeDef",
    {
        "Tags": List[TagTypeDef],
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

GridViewConfigurationTypeDef = TypedDict(
    "GridViewConfigurationTypeDef",
    {
        "ContentShareLayout": ContentShareLayoutOptionType,
        "PresenterOnlyConfiguration": NotRequired[PresenterOnlyConfigurationTypeDef],
        "ActiveSpeakerOnlyConfiguration": NotRequired[ActiveSpeakerOnlyConfigurationTypeDef],
        "HorizontalLayoutConfiguration": NotRequired[HorizontalLayoutConfigurationTypeDef],
        "VerticalLayoutConfiguration": NotRequired[VerticalLayoutConfigurationTypeDef],
        "VideoAttribute": NotRequired[VideoAttributeTypeDef],
        "CanvasOrientation": NotRequired[CanvasOrientationType],
    },
)

ListMediaCapturePipelinesResponseTypeDef = TypedDict(
    "ListMediaCapturePipelinesResponseTypeDef",
    {
        "MediaCapturePipelines": List[MediaCapturePipelineSummaryTypeDef],
        "NextToken": str,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

ListMediaInsightsPipelineConfigurationsResponseTypeDef = TypedDict(
    "ListMediaInsightsPipelineConfigurationsResponseTypeDef",
    {
        "MediaInsightsPipelineConfigurations": List[
            MediaInsightsPipelineConfigurationSummaryTypeDef
        ],
        "NextToken": str,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

ListMediaPipelinesResponseTypeDef = TypedDict(
    "ListMediaPipelinesResponseTypeDef",
    {
        "MediaPipelines": List[MediaPipelineSummaryTypeDef],
        "NextToken": str,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

LiveConnectorSinkConfigurationTypeDef = TypedDict(
    "LiveConnectorSinkConfigurationTypeDef",
    {
        "SinkType": Literal["RTMP"],
        "RTMPConfiguration": LiveConnectorRTMPConfigurationTypeDef,
    },
)

RealTimeAlertRuleTypeDef = TypedDict(
    "RealTimeAlertRuleTypeDef",
    {
        "Type": RealTimeAlertRuleTypeType,
        "KeywordMatchConfiguration": NotRequired[KeywordMatchConfigurationTypeDef],
        "SentimentConfiguration": NotRequired[SentimentConfigurationTypeDef],
        "IssueDetectionConfiguration": NotRequired[IssueDetectionConfigurationTypeDef],
    },
)

SourceConfigurationTypeDef = TypedDict(
    "SourceConfigurationTypeDef",
    {
        "SelectedVideoStreams": NotRequired[SelectedVideoStreamsTypeDef],
    },
)

TimestampRangeTypeDef = TypedDict(
    "TimestampRangeTypeDef",
    {
        "StartTimestamp": TimestampTypeDef,
        "EndTimestamp": TimestampTypeDef,
    },
)

MediaInsightsPipelineConfigurationElementTypeDef = TypedDict(
    "MediaInsightsPipelineConfigurationElementTypeDef",
    {
        "Type": MediaInsightsPipelineConfigurationElementTypeType,
        "AmazonTranscribeCallAnalyticsProcessorConfiguration": NotRequired[
            AmazonTranscribeCallAnalyticsProcessorConfigurationTypeDef
        ],
        "AmazonTranscribeProcessorConfiguration": NotRequired[
            AmazonTranscribeProcessorConfigurationTypeDef
        ],
        "KinesisDataStreamSinkConfiguration": NotRequired[
            KinesisDataStreamSinkConfigurationTypeDef
        ],
        "S3RecordingSinkConfiguration": NotRequired[S3RecordingSinkConfigurationTypeDef],
        "VoiceAnalyticsProcessorConfiguration": NotRequired[
            VoiceAnalyticsProcessorConfigurationTypeDef
        ],
        "LambdaFunctionSinkConfiguration": NotRequired[LambdaFunctionSinkConfigurationTypeDef],
        "SqsQueueSinkConfiguration": NotRequired[SqsQueueSinkConfigurationTypeDef],
        "SnsTopicSinkConfiguration": NotRequired[SnsTopicSinkConfigurationTypeDef],
    },
)

ChimeSdkMeetingConcatenationConfigurationTypeDef = TypedDict(
    "ChimeSdkMeetingConcatenationConfigurationTypeDef",
    {
        "ArtifactsConfiguration": ArtifactsConcatenationConfigurationTypeDef,
    },
)

StreamConfigurationTypeDef = TypedDict(
    "StreamConfigurationTypeDef",
    {
        "StreamArn": str,
        "StreamChannelDefinition": StreamChannelDefinitionTypeDef,
        "FragmentNumber": NotRequired[str],
    },
)

CompositedVideoArtifactsConfigurationTypeDef = TypedDict(
    "CompositedVideoArtifactsConfigurationTypeDef",
    {
        "GridViewConfiguration": GridViewConfigurationTypeDef,
        "Layout": NotRequired[Literal["GridView"]],
        "Resolution": NotRequired[ResolutionOptionType],
    },
)

RealTimeAlertConfigurationTypeDef = TypedDict(
    "RealTimeAlertConfigurationTypeDef",
    {
        "Disabled": NotRequired[bool],
        "Rules": NotRequired[Sequence[RealTimeAlertRuleTypeDef]],
    },
)

FragmentSelectorTypeDef = TypedDict(
    "FragmentSelectorTypeDef",
    {
        "FragmentSelectorType": FragmentSelectorTypeType,
        "TimestampRange": TimestampRangeTypeDef,
    },
)

MediaCapturePipelineSourceConfigurationTypeDef = TypedDict(
    "MediaCapturePipelineSourceConfigurationTypeDef",
    {
        "MediaPipelineArn": str,
        "ChimeSdkMeetingConfiguration": ChimeSdkMeetingConcatenationConfigurationTypeDef,
    },
)

KinesisVideoStreamSourceRuntimeConfigurationTypeDef = TypedDict(
    "KinesisVideoStreamSourceRuntimeConfigurationTypeDef",
    {
        "Streams": Sequence[StreamConfigurationTypeDef],
        "MediaEncoding": Literal["pcm"],
        "MediaSampleRate": int,
    },
)

ArtifactsConfigurationTypeDef = TypedDict(
    "ArtifactsConfigurationTypeDef",
    {
        "Audio": AudioArtifactsConfigurationTypeDef,
        "Video": VideoArtifactsConfigurationTypeDef,
        "Content": ContentArtifactsConfigurationTypeDef,
        "CompositedVideo": NotRequired[CompositedVideoArtifactsConfigurationTypeDef],
    },
)

ChimeSdkMeetingLiveConnectorConfigurationTypeDef = TypedDict(
    "ChimeSdkMeetingLiveConnectorConfigurationTypeDef",
    {
        "Arn": str,
        "MuxType": LiveConnectorMuxTypeType,
        "CompositedVideo": NotRequired[CompositedVideoArtifactsConfigurationTypeDef],
        "SourceConfiguration": NotRequired[SourceConfigurationTypeDef],
    },
)

CreateMediaInsightsPipelineConfigurationRequestRequestTypeDef = TypedDict(
    "CreateMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    {
        "MediaInsightsPipelineConfigurationName": str,
        "ResourceAccessRoleArn": str,
        "Elements": Sequence[MediaInsightsPipelineConfigurationElementTypeDef],
        "RealTimeAlertConfiguration": NotRequired[RealTimeAlertConfigurationTypeDef],
        "Tags": NotRequired[Sequence[TagTypeDef]],
        "ClientRequestToken": NotRequired[str],
    },
)

MediaInsightsPipelineConfigurationTypeDef = TypedDict(
    "MediaInsightsPipelineConfigurationTypeDef",
    {
        "MediaInsightsPipelineConfigurationName": NotRequired[str],
        "MediaInsightsPipelineConfigurationArn": NotRequired[str],
        "ResourceAccessRoleArn": NotRequired[str],
        "RealTimeAlertConfiguration": NotRequired[RealTimeAlertConfigurationTypeDef],
        "Elements": NotRequired[List[MediaInsightsPipelineConfigurationElementTypeDef]],
        "MediaInsightsPipelineConfigurationId": NotRequired[str],
        "CreatedTimestamp": NotRequired[datetime],
        "UpdatedTimestamp": NotRequired[datetime],
    },
)

UpdateMediaInsightsPipelineConfigurationRequestRequestTypeDef = TypedDict(
    "UpdateMediaInsightsPipelineConfigurationRequestRequestTypeDef",
    {
        "Identifier": str,
        "ResourceAccessRoleArn": str,
        "Elements": Sequence[MediaInsightsPipelineConfigurationElementTypeDef],
        "RealTimeAlertConfiguration": NotRequired[RealTimeAlertConfigurationTypeDef],
    },
)

KinesisVideoStreamRecordingSourceRuntimeConfigurationTypeDef = TypedDict(
    "KinesisVideoStreamRecordingSourceRuntimeConfigurationTypeDef",
    {
        "Streams": Sequence[RecordingStreamConfigurationTypeDef],
        "FragmentSelector": FragmentSelectorTypeDef,
    },
)

ConcatenationSourceTypeDef = TypedDict(
    "ConcatenationSourceTypeDef",
    {
        "Type": Literal["MediaCapturePipeline"],
        "MediaCapturePipelineSourceConfiguration": MediaCapturePipelineSourceConfigurationTypeDef,
    },
)

ChimeSdkMeetingConfigurationTypeDef = TypedDict(
    "ChimeSdkMeetingConfigurationTypeDef",
    {
        "SourceConfiguration": NotRequired[SourceConfigurationTypeDef],
        "ArtifactsConfiguration": NotRequired[ArtifactsConfigurationTypeDef],
    },
)

LiveConnectorSourceConfigurationTypeDef = TypedDict(
    "LiveConnectorSourceConfigurationTypeDef",
    {
        "SourceType": Literal["ChimeSdkMeeting"],
        "ChimeSdkMeetingLiveConnectorConfiguration": (
            ChimeSdkMeetingLiveConnectorConfigurationTypeDef
        ),
    },
)

CreateMediaInsightsPipelineConfigurationResponseTypeDef = TypedDict(
    "CreateMediaInsightsPipelineConfigurationResponseTypeDef",
    {
        "MediaInsightsPipelineConfiguration": MediaInsightsPipelineConfigurationTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

GetMediaInsightsPipelineConfigurationResponseTypeDef = TypedDict(
    "GetMediaInsightsPipelineConfigurationResponseTypeDef",
    {
        "MediaInsightsPipelineConfiguration": MediaInsightsPipelineConfigurationTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

UpdateMediaInsightsPipelineConfigurationResponseTypeDef = TypedDict(
    "UpdateMediaInsightsPipelineConfigurationResponseTypeDef",
    {
        "MediaInsightsPipelineConfiguration": MediaInsightsPipelineConfigurationTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

CreateMediaInsightsPipelineRequestRequestTypeDef = TypedDict(
    "CreateMediaInsightsPipelineRequestRequestTypeDef",
    {
        "MediaInsightsPipelineConfigurationArn": str,
        "KinesisVideoStreamSourceRuntimeConfiguration": NotRequired[
            KinesisVideoStreamSourceRuntimeConfigurationTypeDef
        ],
        "MediaInsightsRuntimeMetadata": NotRequired[Mapping[str, str]],
        "KinesisVideoStreamRecordingSourceRuntimeConfiguration": NotRequired[
            KinesisVideoStreamRecordingSourceRuntimeConfigurationTypeDef
        ],
        "S3RecordingSinkRuntimeConfiguration": NotRequired[
            S3RecordingSinkRuntimeConfigurationTypeDef
        ],
        "Tags": NotRequired[Sequence[TagTypeDef]],
        "ClientRequestToken": NotRequired[str],
    },
)

MediaInsightsPipelineTypeDef = TypedDict(
    "MediaInsightsPipelineTypeDef",
    {
        "MediaPipelineId": NotRequired[str],
        "MediaPipelineArn": NotRequired[str],
        "MediaInsightsPipelineConfigurationArn": NotRequired[str],
        "Status": NotRequired[MediaPipelineStatusType],
        "KinesisVideoStreamSourceRuntimeConfiguration": NotRequired[
            KinesisVideoStreamSourceRuntimeConfigurationTypeDef
        ],
        "MediaInsightsRuntimeMetadata": NotRequired[Dict[str, str]],
        "KinesisVideoStreamRecordingSourceRuntimeConfiguration": NotRequired[
            KinesisVideoStreamRecordingSourceRuntimeConfigurationTypeDef
        ],
        "S3RecordingSinkRuntimeConfiguration": NotRequired[
            S3RecordingSinkRuntimeConfigurationTypeDef
        ],
        "CreatedTimestamp": NotRequired[datetime],
    },
)

CreateMediaConcatenationPipelineRequestRequestTypeDef = TypedDict(
    "CreateMediaConcatenationPipelineRequestRequestTypeDef",
    {
        "Sources": Sequence[ConcatenationSourceTypeDef],
        "Sinks": Sequence[ConcatenationSinkTypeDef],
        "ClientRequestToken": NotRequired[str],
        "Tags": NotRequired[Sequence[TagTypeDef]],
    },
)

MediaConcatenationPipelineTypeDef = TypedDict(
    "MediaConcatenationPipelineTypeDef",
    {
        "MediaPipelineId": NotRequired[str],
        "MediaPipelineArn": NotRequired[str],
        "Sources": NotRequired[List[ConcatenationSourceTypeDef]],
        "Sinks": NotRequired[List[ConcatenationSinkTypeDef]],
        "Status": NotRequired[MediaPipelineStatusType],
        "CreatedTimestamp": NotRequired[datetime],
        "UpdatedTimestamp": NotRequired[datetime],
    },
)

CreateMediaCapturePipelineRequestRequestTypeDef = TypedDict(
    "CreateMediaCapturePipelineRequestRequestTypeDef",
    {
        "SourceType": Literal["ChimeSdkMeeting"],
        "SourceArn": str,
        "SinkType": Literal["S3Bucket"],
        "SinkArn": str,
        "ClientRequestToken": NotRequired[str],
        "ChimeSdkMeetingConfiguration": NotRequired[ChimeSdkMeetingConfigurationTypeDef],
        "Tags": NotRequired[Sequence[TagTypeDef]],
    },
)

MediaCapturePipelineTypeDef = TypedDict(
    "MediaCapturePipelineTypeDef",
    {
        "MediaPipelineId": NotRequired[str],
        "MediaPipelineArn": NotRequired[str],
        "SourceType": NotRequired[Literal["ChimeSdkMeeting"]],
        "SourceArn": NotRequired[str],
        "Status": NotRequired[MediaPipelineStatusType],
        "SinkType": NotRequired[Literal["S3Bucket"]],
        "SinkArn": NotRequired[str],
        "CreatedTimestamp": NotRequired[datetime],
        "UpdatedTimestamp": NotRequired[datetime],
        "ChimeSdkMeetingConfiguration": NotRequired[ChimeSdkMeetingConfigurationTypeDef],
    },
)

CreateMediaLiveConnectorPipelineRequestRequestTypeDef = TypedDict(
    "CreateMediaLiveConnectorPipelineRequestRequestTypeDef",
    {
        "Sources": Sequence[LiveConnectorSourceConfigurationTypeDef],
        "Sinks": Sequence[LiveConnectorSinkConfigurationTypeDef],
        "ClientRequestToken": NotRequired[str],
        "Tags": NotRequired[Sequence[TagTypeDef]],
    },
)

MediaLiveConnectorPipelineTypeDef = TypedDict(
    "MediaLiveConnectorPipelineTypeDef",
    {
        "Sources": NotRequired[List[LiveConnectorSourceConfigurationTypeDef]],
        "Sinks": NotRequired[List[LiveConnectorSinkConfigurationTypeDef]],
        "MediaPipelineId": NotRequired[str],
        "MediaPipelineArn": NotRequired[str],
        "Status": NotRequired[MediaPipelineStatusType],
        "CreatedTimestamp": NotRequired[datetime],
        "UpdatedTimestamp": NotRequired[datetime],
    },
)

CreateMediaInsightsPipelineResponseTypeDef = TypedDict(
    "CreateMediaInsightsPipelineResponseTypeDef",
    {
        "MediaInsightsPipeline": MediaInsightsPipelineTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

CreateMediaConcatenationPipelineResponseTypeDef = TypedDict(
    "CreateMediaConcatenationPipelineResponseTypeDef",
    {
        "MediaConcatenationPipeline": MediaConcatenationPipelineTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

CreateMediaCapturePipelineResponseTypeDef = TypedDict(
    "CreateMediaCapturePipelineResponseTypeDef",
    {
        "MediaCapturePipeline": MediaCapturePipelineTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

GetMediaCapturePipelineResponseTypeDef = TypedDict(
    "GetMediaCapturePipelineResponseTypeDef",
    {
        "MediaCapturePipeline": MediaCapturePipelineTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

CreateMediaLiveConnectorPipelineResponseTypeDef = TypedDict(
    "CreateMediaLiveConnectorPipelineResponseTypeDef",
    {
        "MediaLiveConnectorPipeline": MediaLiveConnectorPipelineTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

MediaPipelineTypeDef = TypedDict(
    "MediaPipelineTypeDef",
    {
        "MediaCapturePipeline": NotRequired[MediaCapturePipelineTypeDef],
        "MediaLiveConnectorPipeline": NotRequired[MediaLiveConnectorPipelineTypeDef],
        "MediaConcatenationPipeline": NotRequired[MediaConcatenationPipelineTypeDef],
        "MediaInsightsPipeline": NotRequired[MediaInsightsPipelineTypeDef],
    },
)

GetMediaPipelineResponseTypeDef = TypedDict(
    "GetMediaPipelineResponseTypeDef",
    {
        "MediaPipeline": MediaPipelineTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)
