# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.13
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt
from empire_platform_api_public_client.models.timescale_nomination_status import TimescaleNominationStatus

class TimescaleNominationsMtusInnerCurrentNomination(BaseModel):
    """
    Optional field for storing Nomination status and value (if any nomination has been made already)  * `flooredValue` - only sent when the current nomination is in FLOORED status * `preCurtailedValue`   - only sent in LOCKED or FIRM status AND   - if the current nomination had a curtailment action before (last draft nomination value) 
    """
    status: TimescaleNominationStatus = Field(...)
    value: StrictInt = Field(..., description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    floored_value: Optional[StrictInt] = Field(None, alias="flooredValue", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    pre_curtailed_value: Optional[StrictInt] = Field(None, alias="preCurtailedValue", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["status", "value", "flooredValue", "preCurtailedValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimescaleNominationsMtusInnerCurrentNomination:
        """Create an instance of TimescaleNominationsMtusInnerCurrentNomination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimescaleNominationsMtusInnerCurrentNomination:
        """Create an instance of TimescaleNominationsMtusInnerCurrentNomination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimescaleNominationsMtusInnerCurrentNomination.parse_obj(obj)

        _obj = TimescaleNominationsMtusInnerCurrentNomination.parse_obj({
            "status": obj.get("status"),
            "value": obj.get("value"),
            "floored_value": obj.get("flooredValue"),
            "pre_curtailed_value": obj.get("preCurtailedValue")
        })
        return _obj

