# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.13
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.attachment import Attachment
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus

class ParticipantDashboardFinanceOverviewInvoice(BaseModel):
    """
    ParticipantDashboardFinanceOverviewInvoice
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    display_id: StrictStr = Field(..., alias="displayId")
    status: InvoiceStatus = Field(...)
    attachment: Optional[Attachment] = None
    due_date: Optional[date] = Field(None, alias="dueDate", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    payment_date: Optional[date] = Field(None, alias="paymentDate", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    __properties = ["id", "displayId", "status", "attachment", "dueDate", "paymentDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParticipantDashboardFinanceOverviewInvoice:
        """Create an instance of ParticipantDashboardFinanceOverviewInvoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of attachment
        if self.attachment:
            _dict['attachment'] = self.attachment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParticipantDashboardFinanceOverviewInvoice:
        """Create an instance of ParticipantDashboardFinanceOverviewInvoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParticipantDashboardFinanceOverviewInvoice.parse_obj(obj)

        _obj = ParticipantDashboardFinanceOverviewInvoice.parse_obj({
            "id": obj.get("id"),
            "display_id": obj.get("displayId"),
            "status": obj.get("status"),
            "attachment": Attachment.from_dict(obj.get("attachment")) if obj.get("attachment") is not None else None,
            "due_date": obj.get("dueDate"),
            "payment_date": obj.get("paymentDate")
        })
        return _obj

