# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.13
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictStr, confloat, conint
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.sage_code import SageCode

class InvoiceLineItem(BaseModel):
    """
    InvoiceLineItem
    """
    id: Optional[StrictStr] = Field(None, description="Unique (at least locally) identifier for the record in UUID4 format  * records received nullable identifiers through GET requests should have the property filled out * records sent to PUT endpoints:   - if property is filled out => backend is expected to update the record   - if property is null or missing => backend is expected to create a new record   - if list of records does not contain the record identifier => backend is expected to delete the record ")
    code: SageCode = Field(...)
    direction: BorderDirection = Field(...)
    delivery_month: conint(strict=True, ge=0) = Field(..., alias="deliveryMonth", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    net_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="netAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    vat_rate: Union[confloat(le=100, ge=0, multiple_of=0.01, strict=True), conint(le=100, ge=0, strict=True)] = Field(..., alias="vatRate", description="Percentage values, accepted with a precision of maximum 2 decimal places")
    vat_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="vatAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    gross_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="grossAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    manually_added: StrictBool = Field(..., alias="manuallyAdded")
    __properties = ["id", "code", "direction", "deliveryMonth", "netAmount", "vatRate", "vatAmount", "grossAmount", "manuallyAdded"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvoiceLineItem:
        """Create an instance of InvoiceLineItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvoiceLineItem:
        """Create an instance of InvoiceLineItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvoiceLineItem.parse_obj(obj)

        _obj = InvoiceLineItem.parse_obj({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "direction": obj.get("direction"),
            "delivery_month": obj.get("deliveryMonth"),
            "net_amount": obj.get("netAmount"),
            "vat_rate": obj.get("vatRate"),
            "vat_amount": obj.get("vatAmount"),
            "gross_amount": obj.get("grossAmount"),
            "manually_added": obj.get("manuallyAdded")
        })
        return _obj

