# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.13
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conlist

from typing import Optional

from empire_platform_api_public_client.models.aggregated_nomination_options import AggregatedNominationOptions
from empire_platform_api_public_client.models.aggregated_nomination_type import AggregatedNominationType
from empire_platform_api_public_client.models.aggregated_nominations import AggregatedNominations
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.submit_timescale_nominations_request import SubmitTimescaleNominationsRequest
from empire_platform_api_public_client.models.timescale_nomination_options import TimescaleNominationOptions
from empire_platform_api_public_client.models.timescale_nomination_type import TimescaleNominationType
from empire_platform_api_public_client.models.timescale_nominations import TimescaleNominations

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class NominationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_aggregated_nomination_options(self, **kwargs) -> AggregatedNominationOptions:  # noqa: E501
        """get_aggregated_nomination_options  # noqa: E501

        Fetch options for Aggregated Nominations  Returns if the current Participant organisation is configured as \"nomination on behalf\" for any Markets. If yes, the list of \"nominees\" returned.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_aggregated_nomination_options(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AggregatedNominationOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_aggregated_nomination_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_aggregated_nomination_options_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_aggregated_nomination_options_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_aggregated_nomination_options  # noqa: E501

        Fetch options for Aggregated Nominations  Returns if the current Participant organisation is configured as \"nomination on behalf\" for any Markets. If yes, the list of \"nominees\" returned.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_aggregated_nomination_options_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AggregatedNominationOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aggregated_nomination_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "AggregatedNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/nominations/aggregated/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_aggregated_nominations(self, delivery_day : date, type : AggregatedNominationType, timescale_types : Optional[conlist(TimescaleNominationType)] = None, x_participant_ids : Annotated[Optional[conlist(StrictStr)], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None, **kwargs) -> AggregatedNominations:  # noqa: E501
        """get_aggregated_nominations  # noqa: E501

        Fetch aggregated Nominatinons for a given:   - delivery day   - type of aggregated nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_aggregated_nominations(delivery_day, type, timescale_types, x_participant_ids, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: AggregatedNominationType
        :param timescale_types:
        :type timescale_types: List[TimescaleNominationType]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AggregatedNominations
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_aggregated_nominations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_aggregated_nominations_with_http_info(delivery_day, type, timescale_types, x_participant_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def get_aggregated_nominations_with_http_info(self, delivery_day : date, type : AggregatedNominationType, timescale_types : Optional[conlist(TimescaleNominationType)] = None, x_participant_ids : Annotated[Optional[conlist(StrictStr)], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_aggregated_nominations  # noqa: E501

        Fetch aggregated Nominatinons for a given:   - delivery day   - type of aggregated nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_aggregated_nominations_with_http_info(delivery_day, type, timescale_types, x_participant_ids, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: AggregatedNominationType
        :param timescale_types:
        :type timescale_types: List[TimescaleNominationType]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AggregatedNominations, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'type',
            'timescale_types',
            'x_participant_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aggregated_nominations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type'].value))

        if _params.get('timescale_types') is not None:  # noqa: E501
            _query_params.append(('timescaleTypes', _params['timescale_types']))
            _collection_formats['timescaleTypes'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_ids']:
            _header_params['X-Participant-Ids'] = _params['x_participant_ids']
            _collection_formats['X-Participant-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "AggregatedNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/nominations/aggregated', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_timescale_nomination_options(self, delivery_day : date, type : TimescaleNominationType, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], **kwargs) -> TimescaleNominationOptions:  # noqa: E501
        """get_timescale_nomination_options  # noqa: E501

        Fetch options for getting Timescale Nomination  Used to determine which are the available directions for which a given Participant has rights to nominate for a given:   - delivery day   - type of nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_timescale_nomination_options(delivery_day, type, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TimescaleNominationOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_timescale_nomination_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_timescale_nomination_options_with_http_info(delivery_day, type, x_participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_timescale_nomination_options_with_http_info(self, delivery_day : date, type : TimescaleNominationType, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_timescale_nomination_options  # noqa: E501

        Fetch options for getting Timescale Nomination  Used to determine which are the available directions for which a given Participant has rights to nominate for a given:   - delivery day   - type of nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_timescale_nomination_options_with_http_info(delivery_day, type, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TimescaleNominationOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'type',
            'x_participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_timescale_nomination_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "TimescaleNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/nominations/timescale/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_timescale_nominations(self, delivery_day : date, type : TimescaleNominationType, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], **kwargs) -> TimescaleNominations:  # noqa: E501
        """get_timescale_nominations  # noqa: E501

        Fetch current Timescale Nominations for a given:   - delivery day   - type of nomination   - particpant   - border direction  MTUs are returned in the timescale's \"Nomination MTU Size\" resolution  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_timescale_nominations(delivery_day, type, x_participant_id, border_direction, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TimescaleNominations
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_timescale_nominations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_timescale_nominations_with_http_info(delivery_day, type, x_participant_id, border_direction, **kwargs)  # noqa: E501

    @validate_arguments
    def get_timescale_nominations_with_http_info(self, delivery_day : date, type : TimescaleNominationType, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_timescale_nominations  # noqa: E501

        Fetch current Timescale Nominations for a given:   - delivery day   - type of nomination   - particpant   - border direction  MTUs are returned in the timescale's \"Nomination MTU Size\" resolution  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_timescale_nominations_with_http_info(delivery_day, type, x_participant_id, border_direction, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TimescaleNominations, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'type',
            'x_participant_id',
            'border_direction'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_timescale_nominations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type'].value))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "TimescaleNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/nominations/timescale', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def submit_timescale_nominations(self, delivery_day : date, type : TimescaleNominationType, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], submit_timescale_nominations_request : SubmitTimescaleNominationsRequest, **kwargs) -> None:  # noqa: E501
        """submit_timescale_nominations  # noqa: E501

        Submit Timescale Nominations for the given:   - delivery day   - type of nomination   - particpant   - border direction  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_TIMESCALE_NOMINATIONS`   * `MANAGE_ANY_TIMESCALE_NOMINATIONS`  __Generates Audit Log Entry:__ `SUBMIT_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_timescale_nominations(delivery_day, type, x_participant_id, border_direction, submit_timescale_nominations_request, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param submit_timescale_nominations_request: (required)
        :type submit_timescale_nominations_request: SubmitTimescaleNominationsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the submit_timescale_nominations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.submit_timescale_nominations_with_http_info(delivery_day, type, x_participant_id, border_direction, submit_timescale_nominations_request, **kwargs)  # noqa: E501

    @validate_arguments
    def submit_timescale_nominations_with_http_info(self, delivery_day : date, type : TimescaleNominationType, x_participant_id : Annotated[StrictStr, Field(..., description="Internal ID of a Participant-type Organisation")], border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], submit_timescale_nominations_request : SubmitTimescaleNominationsRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """submit_timescale_nominations  # noqa: E501

        Submit Timescale Nominations for the given:   - delivery day   - type of nomination   - particpant   - border direction  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_TIMESCALE_NOMINATIONS`   * `MANAGE_ANY_TIMESCALE_NOMINATIONS`  __Generates Audit Log Entry:__ `SUBMIT_TIMESCALE_NOMINATIONS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_timescale_nominations_with_http_info(delivery_day, type, x_participant_id, border_direction, submit_timescale_nominations_request, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param submit_timescale_nominations_request: (required)
        :type submit_timescale_nominations_request: SubmitTimescaleNominationsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'type',
            'x_participant_id',
            'border_direction',
            'submit_timescale_nominations_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_timescale_nominations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type'].value))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['submit_timescale_nominations_request'] is not None:
            _body_params = _params['submit_timescale_nominations_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/nominations/timescale', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
