/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StorageResourceId {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final long UNKNOWN_GENERATION_ID = -1L;
    private static final Pattern GCS_PATH_PATTERN = Pattern.compile("gs://(([^/]+)(/(.+)?)?)?");
    public static final StorageResourceId ROOT = new StorageResourceId();
    private final String bucketName;
    private final String objectName;
    private final String stringPath;
    private final long generationId;

    private StorageResourceId() {
        this.bucketName = null;
        this.objectName = null;
        this.stringPath = StringPaths.fromComponents(this.bucketName, this.objectName);
        this.generationId = -1L;
    }

    public StorageResourceId(String bucketName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = null;
        this.stringPath = StringPaths.fromComponents(bucketName, this.objectName);
        this.generationId = -1L;
    }

    public StorageResourceId(String bucketName, String objectName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(objectName), "objectName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.stringPath = StringPaths.fromComponents(bucketName, objectName);
        this.generationId = -1L;
    }

    public StorageResourceId(String bucketName, String objectName, long generationId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(objectName), "objectName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.stringPath = StringPaths.fromComponents(bucketName, objectName);
        this.generationId = generationId;
    }

    public StorageResourceId(String bucketName, long generationId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = null;
        this.stringPath = StringPaths.fromComponents(bucketName, this.objectName);
        this.generationId = generationId;
    }

    public boolean isStorageObject() {
        return this.bucketName != null && this.objectName != null;
    }

    public boolean isBucket() {
        return this.bucketName != null && this.objectName == null;
    }

    public boolean isRoot() {
        return this.bucketName == null && this.objectName == null;
    }

    public boolean isDirectory() {
        return this.isRoot() || this.isBucket() || StringPaths.isDirectoryPath(this.objectName);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public boolean hasGenerationId() {
        return this.generationId != -1L;
    }

    public String toString() {
        return this.stringPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageResourceId) {
            StorageResourceId other = (StorageResourceId)obj;
            return Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName);
        }
        return false;
    }

    public int hashCode() {
        return this.stringPath.hashCode();
    }

    public StorageResourceId toDirectoryId() {
        if (this.isStorageObject() && !StringPaths.isDirectoryPath(this.getObjectName())) {
            return new StorageResourceId(this.getBucketName(), StringPaths.toDirectoryPath(this.getObjectName()));
        }
        return this;
    }

    public static StorageResourceId fromStringPath(String path) {
        return StorageResourceId.fromStringPath(path, -1L);
    }

    public static StorageResourceId fromStringPath(String path, long generationId) {
        Matcher matcher = GCS_PATH_PATTERN.matcher(path);
        Preconditions.checkArgument(matcher.matches(), "'%s' is not a valid GCS object name.", (Object)path);
        String bucketName = matcher.group(2);
        String relativePath = matcher.group(4);
        if (bucketName == null) {
            Preconditions.checkArgument(generationId == -1L, "Cannot specify generationId '%s' for root object '%s'", generationId, (Object)path);
            return ROOT;
        }
        if (relativePath != null) {
            return new StorageResourceId(bucketName, relativePath, generationId);
        }
        Preconditions.checkArgument(generationId == -1L, "Cannot specify generationId '%s' for bucket '%s'", generationId, (Object)path);
        return new StorageResourceId(bucketName);
    }

    public static StorageResourceId fromUriPath(URI path, boolean allowEmptyObjectName) {
        return StorageResourceId.fromUriPath(path, allowEmptyObjectName, -1L);
    }

    public static StorageResourceId fromUriPath(URI path, boolean allowEmptyObjectName, long generationId) {
        ((GoogleLogger.Api)logger.atFiner()).log("fromUriPath('%s', %s)", (Object)path, allowEmptyObjectName);
        Preconditions.checkNotNull(path);
        if (!"gs".equals(path.getScheme())) {
            throw new IllegalArgumentException(String.format("GCS path supports only '%s' scheme, instead got '%s' from '%s'.", "gs", path.getScheme(), path));
        }
        if (path.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
            return ROOT;
        }
        String bucketName = StringPaths.validateBucketName(path.getAuthority());
        String objectName = StringPaths.validateObjectName(path.getPath(), allowEmptyObjectName);
        return Strings.isNullOrEmpty(objectName) ? new StorageResourceId(bucketName, generationId) : new StorageResourceId(bucketName, objectName, generationId);
    }
}

