# FalcoTCP-Py

Secure TCP server/client with AES-256-GCM encryption for trusted endpoint communication, like server-to-microservices or server-to-database. Handles authentication, messaging, and pings, with load-balanced worker distribution.

## Why does this project exist?

This project was created to simplify the development of connection handlers. It abstracts the TCP layer without any hand-holding—remaining low-level while still providing a clean and minimal abstraction.

## Protocol

Works with the server listening to the host address. When a client tries to connect, it sends a chunk of bytes encrypted with AES-GCM-256. If the server decrypts the request, the connection is successfully established; the TCP socket is shut down otherwise.

After connecting, every connection has a lifetime of 60 seconds, the countdown being reset after any sort of interaction, it being able to be either a ping or message.

When the server receives a message from the client, it decrypts the message (everything in the network is encrypted by default) and calls a function (message handler) which gets these bytes as parameters and returns bytes that are encrypted and sent back to the client. It decrypts the bytes from the server and returns them to the client runtime.

## Binary structure

Like any protocol that operates with byte transfers, this one also has its own structure, which is shown below. It begins with a request type defined as a u8 (an unsigned 8-bit integer). Currently, three request types are registered:
- 0 — connection establishment
- 1 — regular message
- 2 — ping (used to prevent the server from closing the connection)

| Request Type | Nonce      | Cipher Text | Tag        |
|--------------|------------|-------------|------------|
| u8           | [u8; 12]   | Vec<u8>     | [u8; 16]   |

The Nonce is a byte sequence used by the AES-256-GCM algorithm. It is similar to a salt in hashing, but not the same. The CipherText is the encrypted payload, and the Tag is an authentication value generated by the AES algorithm.

## Errors and Treatment

Error handling varies depending on the request type, since each type is interpreted differently. For request type 0 (authentication/connection establishment), if the cipher text fails to decrypt, the server treats the client as foreign and unauthorized. In response, the server silently closes the connection without sending any message or notification. The server assumes that legitimate clients will always use the correct password.

For request type 1 (message sending), if the server fails to decrypt the payload, it interprets this as a transmission failure and returns an empty response (a u64 with the value 0, simulating a response of length 0).

For request type 2 (ping), no decryption is performed and no error handling is needed, since only the request type is relevant.

If an unregistered request type is received, the server ignores it without taking any action.

## Security

The security of the protocol relies entirely on password management. This password is essentially a secret key, so treat it as such and protect it properly. It must be a fixed-size array of 32 bytes, generated using a cryptographically secure method. The password is the main pillar of the protocol's safety — which is expected, as TLS (over HTTP) works similarly. The difference here is that the password is managed by you, the operator.
