# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
import os

# Local
from .base_addon_install_settings import BaseAddonInstallSettings

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# --------------------------------------------------------------- Defines ---------------------------------------------------------------- #

RESOURCES_FOLDER_NAME = 'resources'


# ---------------------------------------------------------------------------------------------------------------------------------------- #



# -------------------------------------------------- class: BuiltinAddonInstallSettings -------------------------------------------------- #

class BuiltinAddonInstallSettings(BaseAddonInstallSettings):

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(self):
        if not self._name.endswith('.xpi'):
            self._name += '.xpi'

        super().__init__(
            os.path.join(
                os.path.dirname(os.path.abspath(__file__)),
                RESOURCES_FOLDER_NAME,
                self._name
            )
        )


    # ------------------------------------------------------ Public properties ------------------------------------------------------- #

    _name: str = ''


# ---------------------------------------------------------------------------------------------------------------------------------------- #