# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-05-01 16:46
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations
from django.db import models


class MPTTRemoveField(migrations.RemoveField):
    def database_backwards(self, app_label, schema_editor, from_state, to_state):
        to_model = to_state.apps.get_model(app_label, self.model_name)
        if self.allow_migrate_model(schema_editor.connection.alias, to_model):
            from_model = from_state.apps.get_model(app_label, self.model_name)
            to_field = to_model._meta.get_field(self.name)
            to_field.default = 0
            schema_editor.add_field(from_model, to_field)


class Migration(migrations.Migration):

    dependencies = [
        ("kolibriauth", "0018_no_i18n_collection_kinds"),
    ]

    operations = [
        MPTTRemoveField(
            model_name="collection",
            name="level",
        ),
        MPTTRemoveField(
            model_name="collection",
            name="lft",
        ),
        MPTTRemoveField(
            model_name="collection",
            name="rght",
        ),
        MPTTRemoveField(
            model_name="collection",
            name="tree_id",
        ),
        migrations.AlterField(
            model_name="collection",
            name="parent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="children",
                to="kolibriauth.Collection",
            ),
        ),
    ]
