# youtube-search-requests
### Search Youtube videos using python requests without Youtube API.
### youtube-search-requests can search up to 120+ videos !

Normally youtube-search-requests only extract urls, you can extract additional information by installing youtube-dl, for more information check usage below.

CLI (Command Line Interface) Usage:
```python

usage: python3 -m youtube_search_requests [-h] [-v] [--max-results={Number}] [-t={Number}] [-ei]
                                          [--json]
 			                   Search terms

Search Youtube videos using python requests without Youtube API

positional arguments:
  Search terms          a string terms want to search (if include space, you
                        must use double quotes "")

optional arguments:
  -h, --help            show this help message and exit
  -v , --validate       validate url results, validating urls takes too much
                        times but it worth to prevent UNPLAYABLE or ERROR
                        videos
  --max-results={Number} 
                        maximum search results
  -t={Number} , --timeout={Number} 
                        give number of times to execute search, if times runs
                        out, search stopped & returning results
  -ei , --extract-info 
                        Extract additional info in urls, NOTE: you need to
                        install youtube-dl module to extract additional info
                        (pip install youtube-dl)
  --json                Return results in json format

example usage:

python3 -m youtube_search_requests "fish" --json

# {"urls": ["https://www.youtube.com/watch?v=0gT8Ty0ClHc", ...]}


```

Simple usage:

```python

from youtube_search_requests import YoutubeSearch

y = YoutubeSearch('fish', max_results=10)
videos = y.search()

print(videos)
```

### also, youtube-search-requests have ability to validate videos
this to prevent UNPLAYABLE or ERROR videos

Search and validating videos usage:
```python

from youtube_search_requests import YoutubeSearch

# by default, validate is set to True
y = YoutubeSearch('delicious fish', max_results=10, validate=True)
videos = y.search()

print(videos)
```

Extracting additional info videos usage:
```python

from youtube_search_requests import YoutubeSearch

# NOTE: this require youtube-dl module
y = YoutubeSearch('fish', max_results=10, validate=True, extract_info=True)
videos = y.search

print(videos)

```

Search with given time usage:
```python

from youtube_search_requests import YoutubeSearch

# given time 60 seconds for searching videos
y = YoutubeSearch('fish', max_results=10, timeout=60) 

# if search not complete after 60 seconds
# force it to return results
videos = y.search()

print(videos)
```
