/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.Server;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class XMLConfigurationBuilder {
    private static final String ELEMENTNAME_LOGICAL_SERVER = "LOGICALSERVER";
    private static final String ELEMENTNAME_SERVER_COMPONENT = "SERVERCOMPONENT";
    private static final String ELEMENTNAME_TCPIP_CONNECTION = "TCPIPCONNECTION";
    private static final String ELEMENTNAME_PROPERTY = "PROPERTY";
    private static final String ELEMENTNAME_AUTHENTICATION_DOMAIN = "AUTHENTICATIONDOMAIN";
    private static final String ELEMENTNAME_LOGIN = "LOGIN";
    private static final String ATTRNAME_CLASS_IDENTIFIER = "CLASSIDENTIFIER";
    private static final String ATTRNAME_PORT = "PORT";
    private static final String ATTRNAME_HOSTNAME = "HOSTNAME";
    private static final String ATTRNAME_APPLICATION_PROTOCOL = "APPLICATIONPROTOCOL";
    private static final String ATTRNAME_NAME = "NAME";
    private static final String ATTRNAME_DEFAULT_VALUE = "DEFAULTVALUE";
    private static final String ATTRNAME_PROPERTY_NAME = "PROPERTYNAME";
    private static final String ATTRNAME_USER_ID = "USERID";
    private static final String ATTRNAME_PASSWORD = "PASSWORD";
    private static final String ATTRVALUE_APPLICATION_PROTOCOL_BRIDGE = "Bridge";
    private static final String ATTRDEFAULT_NAME = "DefaultAuth";
    private static final String ATTRDEFAULT_HOSTNAME = "localhost";
    private static final String ATTRDEFAULT_PORT = "8561";
    private static final String PROPERTYNAME_REQUIRED_ENCRYPTION_LEVEL = "RequiredEncryptionLevel";
    private static final String PROPERTYNAME_SERVER_ENCRYPTION_ALGORITHMS = "ServerEncryptionAlgorithms";
    private static final String PROPERTYNAME_SECURITY_PACKAGE = "SecurityPackage";
    private static final String PROPERTYNAME_SECURITY_PACKAGE_LIST = "SecurityPackageList";
    private static final String PROPERTYNAME_SPN = "SPN";
    private static final String PROPERTYVALUE_REQUIRED_ENCRYPTION_LEVEL_CREDENTIALS = "credentials";
    private static final String PROPERTYVALUE_REQUIRED_ENCRYPTION_LEVEL_EVERYTHING = "everything";
    private static DocumentBuilderFactory _docBuilderFactory;
    private ManualConnectionFactoryConfiguration _config;
    private Map _credMap = new HashMap(4);
    private Map _clusterMap = new HashMap(4);
    private Stack _parseStk = new Stack();

    public XMLConfigurationBuilder(File serverInfoFile) throws ConnectionFactoryException {
        this(serverInfoFile, null);
    }

    public XMLConfigurationBuilder(File serverInfoFile, File userInfoFile) throws ConnectionFactoryException {
        this();
        try {
            DocumentBuilder serverInfoDocBuilder = XMLConfigurationBuilder.getDocumentBuilder();
            Document serverInfoDoc = serverInfoDocBuilder.parse(serverInfoFile);
            Element serverInfoNode = serverInfoDoc.getDocumentElement();
            this.addElementNode(serverInfoNode);
            if (userInfoFile != null) {
                DocumentBuilder userInfoDocBuilder = XMLConfigurationBuilder.getDocumentBuilder();
                Document userInfoDoc = userInfoDocBuilder.parse(userInfoFile);
                Element userInfoNode = userInfoDoc.getDocumentElement();
                this.addElementNode(userInfoNode);
            }
        }
        catch (IOException ioe) {
            throw new ConnectionFactoryException(ioe);
        }
        catch (SAXException saxe) {
            throw new ConnectionFactoryException(saxe);
        }
    }

    private XMLConfigurationBuilder() {
    }

    @SASScope
    public static XMLConfigurationBuilder getInstance(Document serverInfoDoc, Document userInfoDoc) throws ConnectionFactoryException {
        XMLConfigurationBuilder builder = new XMLConfigurationBuilder();
        Element serverInfoNode = serverInfoDoc.getDocumentElement();
        builder.addElementNode(serverInfoNode);
        if (userInfoDoc != null) {
            Element userInfoNode = userInfoDoc.getDocumentElement();
            builder.addElementNode(userInfoNode);
        }
        return builder;
    }

    public ManualConnectionFactoryConfiguration getConfiguration() {
        return this._config;
    }

    public Credential getCredentialForDomain(String domain) {
        Credential cred = (Credential)this._credMap.get(domain);
        return cred;
    }

    private void addNodeChildren(Node node) throws ConnectionFactoryException {
        NodeList childLst = node.getChildNodes();
        int childLstL = childLst.getLength();
        block4: for (int i = 0; i < childLstL; ++i) {
            Node child = childLst.item(i);
            short childType = child.getNodeType();
            switch (childType) {
                case 1: {
                    this.addElementNode(child);
                    continue block4;
                }
                case 3: {
                    continue block4;
                }
                default: {
                    this.addNodeChildren(child);
                }
            }
        }
    }

    private void addElementNode(Node node) throws ConnectionFactoryException {
        String nodeType = node.getNodeName();
        String nodeTypeU = nodeType.toUpperCase(Locale.US);
        if (ELEMENTNAME_LOGICAL_SERVER.equals(nodeTypeU)) {
            LogicalServerProperties lsProperties = new LogicalServerProperties();
            this._parseStk.push(lsProperties);
            this.addNodeChildren(node);
            this._parseStk.pop();
            Set mapEntries = this._clusterMap.entrySet();
            Iterator entryItor = mapEntries.iterator();
            Cluster[] clusters = new Cluster[mapEntries.size()];
            int i = 0;
            while (entryItor.hasNext()) {
                Map.Entry entry = entryItor.next();
                Set serverSet = (Set)entry.getValue();
                int serverCount = serverSet.size();
                Server[] servers = new Server[serverCount];
                servers = serverSet.toArray(servers);
                for (int j = 0; j < servers.length; ++j) {
                    String spn;
                    String securityPackageList;
                    Server server = servers[j];
                    String securityPackage = lsProperties.getSecurityPackage();
                    if (securityPackage != null) {
                        server.setSecurityPackage(securityPackage);
                    }
                    if ((securityPackageList = lsProperties.getSecurityPackageList()) != null) {
                        server.setSecurityPackageList(securityPackageList);
                    }
                    if ((spn = lsProperties.getSPN()) == null) continue;
                    server.setSPN(spn);
                }
                clusters[i++] = Cluster.getInstance(servers, 1);
            }
            this._config = new ManualConnectionFactoryConfiguration(clusters);
        } else if (ELEMENTNAME_SERVER_COMPONENT.equals(nodeTypeU)) {
            NamedNodeMap attrMap = node.getAttributes();
            int attrMapL = attrMap != null ? attrMap.getLength() : 0;
            String classID = null;
            for (int i = 0; i < attrMapL; ++i) {
                Node attr = attrMap.item(i);
                String attrName = attr.getNodeName();
                String attrNameU = attrName.toUpperCase(Locale.US);
                if (!ATTRNAME_CLASS_IDENTIFIER.equals(attrNameU)) continue;
                classID = attr.getNodeValue();
            }
            if (classID == null) {
                classID = "0217e202-b560-11db-ad91-001083ff6836";
            }
            this._parseStk.push(classID);
            this.addNodeChildren(node);
            this._parseStk.pop();
        } else if (ELEMENTNAME_TCPIP_CONNECTION.equals(nodeTypeU)) {
            NamedNodeMap attrMap = node.getAttributes();
            int attrMapL = attrMap != null ? attrMap.getLength() : 0;
            String portS = null;
            String hostName = null;
            String applicationProtocol = null;
            for (int i = 0; i < attrMapL; ++i) {
                Node attr = attrMap.item(i);
                String attrName = attr.getNodeName();
                String attrNameU = attrName.toUpperCase(Locale.US);
                if (ATTRNAME_PORT.equals(attrNameU)) {
                    portS = attr.getNodeValue();
                    continue;
                }
                if (ATTRNAME_HOSTNAME.equals(attrNameU)) {
                    hostName = attr.getNodeValue();
                    continue;
                }
                if (!ATTRNAME_APPLICATION_PROTOCOL.equals(attrNameU)) continue;
                applicationProtocol = attr.getNodeValue();
            }
            if (ATTRVALUE_APPLICATION_PROTOCOL_BRIDGE.equals(applicationProtocol)) {
                if (portS == null) {
                    portS = ATTRDEFAULT_PORT;
                }
                if (hostName == null) {
                    hostName = ATTRDEFAULT_HOSTNAME;
                }
                String classID = (String)this._parseStk.peek();
                int port = Integer.parseInt(portS);
                BridgeServer server = new BridgeServer(classID, hostName, port);
                this._parseStk.push(server);
                this.addNodeChildren(node);
                this._parseStk.pop();
                this.addServer(server);
            }
        } else if (ELEMENTNAME_PROPERTY.equals(nodeTypeU)) {
            NamedNodeMap attrMap = node.getAttributes();
            int attrMapL = attrMap != null ? attrMap.getLength() : 0;
            String defaultValue = null;
            String propertyName = null;
            for (int i = 0; i < attrMapL; ++i) {
                Node attr = attrMap.item(i);
                String attrName = attr.getNodeName();
                String attrNameU = attrName.toUpperCase(Locale.US);
                if (ATTRNAME_DEFAULT_VALUE.equals(attrNameU)) {
                    defaultValue = attr.getNodeValue();
                    continue;
                }
                if (!ATTRNAME_PROPERTY_NAME.equals(attrNameU)) continue;
                propertyName = attr.getNodeValue();
            }
            Object obj = this._parseStk.peek();
            if (obj instanceof BridgeServer) {
                BridgeServer server = (BridgeServer)obj;
                if (PROPERTYNAME_REQUIRED_ENCRYPTION_LEVEL.equals(propertyName)) {
                    if (PROPERTYVALUE_REQUIRED_ENCRYPTION_LEVEL_CREDENTIALS.equals(defaultValue)) {
                        server.setEncryptionPolicy("required");
                        server.setEncryptionContent("authentication");
                    } else if (PROPERTYVALUE_REQUIRED_ENCRYPTION_LEVEL_EVERYTHING.equals(defaultValue)) {
                        server.setEncryptionPolicy("required");
                        server.setEncryptionContent("all");
                    } else {
                        server.setEncryptionPolicy("none");
                    }
                } else if (PROPERTYNAME_SERVER_ENCRYPTION_ALGORITHMS.equals(propertyName)) {
                    server.setEncryptionAlgorithms(defaultValue);
                }
            } else if (obj instanceof LogicalServerProperties) {
                LogicalServerProperties lsProperties = (LogicalServerProperties)obj;
                if (PROPERTYNAME_SECURITY_PACKAGE.equals(propertyName)) {
                    lsProperties.setSecurityPackage(defaultValue);
                } else if (PROPERTYNAME_SECURITY_PACKAGE_LIST.equals(propertyName)) {
                    lsProperties.setSecurityPackageList(defaultValue);
                } else if (PROPERTYNAME_SPN.equals(propertyName)) {
                    lsProperties.setSPN(defaultValue);
                }
            }
        } else if (ELEMENTNAME_AUTHENTICATION_DOMAIN.equals(nodeTypeU)) {
            BridgeServer server;
            NamedNodeMap attrMap = node.getAttributes();
            int attrMapL = attrMap != null ? attrMap.getLength() : 0;
            String name = null;
            for (int i = 0; i < attrMapL; ++i) {
                Node attr = attrMap.item(i);
                String attrName = attr.getNodeName();
                String attrNameU = attrName.toUpperCase(Locale.US);
                if (!ATTRNAME_NAME.equals(attrNameU)) continue;
                name = attr.getNodeValue();
            }
            if (name == null) {
                name = ATTRDEFAULT_NAME;
            }
            BridgeServer bridgeServer = server = !this._parseStk.isEmpty() ? (BridgeServer)this._parseStk.peek() : null;
            if (server != null) {
                server.setDomain(name);
            }
            this._parseStk.push(name);
            this.addNodeChildren(node);
            this._parseStk.pop();
        } else if (ELEMENTNAME_LOGIN.equals(nodeTypeU)) {
            NamedNodeMap attrMap = node.getAttributes();
            int attrMapL = attrMap != null ? attrMap.getLength() : 0;
            String userID = null;
            String password = null;
            for (int i = 0; i < attrMapL; ++i) {
                Node attr = attrMap.item(i);
                String attrName = attr.getNodeName();
                String attrNameU = attrName.toUpperCase(Locale.US);
                if (ATTRNAME_USER_ID.equals(attrNameU)) {
                    userID = attr.getNodeValue();
                    continue;
                }
                if (!ATTRNAME_PASSWORD.equals(attrNameU)) continue;
                password = attr.getNodeValue();
            }
            String domain = (String)this._parseStk.peek();
            PasswordCredential cred = new PasswordCredential(userID, password, domain);
            this.addCredential(cred);
        } else {
            this.addNodeChildren(node);
        }
    }

    private void addServer(Server server) {
        String domain = server.getDomain();
        HashSet<Server> serverSet = (HashSet<Server>)this._clusterMap.get(domain);
        if (serverSet == null) {
            serverSet = new HashSet<Server>(8);
            this._clusterMap.put(domain, serverSet);
        }
        serverSet.add(server);
    }

    private void addCredential(Credential cred) {
        String domain = cred.getDomain();
        this._credMap.put(domain, cred);
    }

    private static DocumentBuilder getDocumentBuilder() throws ConnectionFactoryException {
        try {
            DocumentBuilderFactory docBuilderFactory = XMLConfigurationBuilder.getDocBuilderFactory();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder;
        }
        catch (ParserConfigurationException pce) {
            throw new ConnectionFactoryException(pce);
        }
    }

    private static synchronized DocumentBuilderFactory getDocBuilderFactory() {
        if (_docBuilderFactory == null) {
            _docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return _docBuilderFactory;
    }

    @SASScope
    private static class LogicalServerProperties {
        private String _securityPackage;
        private String _securityPackageList;
        private String _spn;

        private LogicalServerProperties() {
        }

        private void setSecurityPackage(String securityPackage) {
            this._securityPackage = securityPackage;
        }

        private String getSecurityPackage() {
            return this._securityPackage;
        }

        private void setSecurityPackageList(String securityPacakgeList) {
            this._securityPackageList = securityPacakgeList;
        }

        private String getSecurityPackageList() {
            return this._securityPackageList;
        }

        private void setSPN(String spn) {
            this._spn = spn;
        }

        private String getSPN() {
            return this._spn;
        }
    }
}

