/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVASQLExceptionUnsupported;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

@SASScope
public class MVADataSource
implements DataSource,
Serializable {
    static final long serialVersionUID = 577216L;
    private String userName = "";
    private String password = "";
    private String dbms = "SQLVIEW ";
    private String dbmsOptions = "";
    private String remarks = "false";
    private String undoPolicyNone = "true";
    private String librefs = "";
    private String encryptionPolicy = "";
    private String encryptionContent = "";
    private String encryptionAlgorithms = "";
    private String applyFormats = "false";
    private String rmiUrl = "";
    private String sasifyTableNames = "default";
    private String coerceNumericTypes = "true";
    private String useSSPI = "none";
    private String spn = "";
    private String serverUrl = "";
    private String serverName = "";
    private int portNumber = 0;
    private String description = "";
    private int segmentLength = 256;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        Properties p = this.generateProperties();
        if (userName != null) {
            p.setProperty("userName", userName);
        }
        if (password != null) {
            p.setProperty("password", password);
        }
        if (this.serverUrl == null || this.serverUrl.length() == 0) {
            this.serverUrl = "jdbc:sasiom://" + this.serverName + ":" + this.portNumber;
        }
        return new MVAConnection(this.serverUrl, p);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public String getApplyFormats() {
        return this.applyFormats;
    }

    public void setApplyFormats(String applyFormats) {
        this.applyFormats = applyFormats == null ? "false" : (!applyFormats.equalsIgnoreCase("true") ? "false" : "true");
    }

    public String getCoerceNumericTypes() {
        return this.coerceNumericTypes;
    }

    public void setCoerceNumericTypes(String coerceNumericTypes) {
        this.coerceNumericTypes = coerceNumericTypes == null ? "true" : (coerceNumericTypes.equalsIgnoreCase("true") ? "true" : "false");
    }

    public String getDbms() {
        return this.dbms;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms == null ? "SQLVIEW" : dbms;
    }

    public String getDbmsOptions() {
        return this.dbmsOptions;
    }

    public void setDbmsOptions(String dbmsOptions) {
        this.dbmsOptions = dbmsOptions == null ? "" : dbmsOptions;
    }

    public String getEncryptionAlgorithms() {
        return this.encryptionAlgorithms;
    }

    public void setEncryptionAlgorithms(String encryptionAlgorithms) {
        this.encryptionAlgorithms = encryptionAlgorithms == null ? "" : encryptionAlgorithms;
    }

    public String getEncryptionContent() {
        return this.encryptionContent;
    }

    public void setEncryptionContent(String encryptionContent) {
        this.encryptionContent = encryptionContent == null ? "" : encryptionContent;
    }

    public String getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public void setEncryptionPolicy(String encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy == null ? "" : encryptionPolicy;
    }

    public String getLibrefs() {
        return this.librefs;
    }

    public void setLibrefs(String librefs) {
        this.librefs = librefs == null ? "" : librefs;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password == null ? "" : password;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? "" : remarks;
    }

    @Deprecated
    public String getRmiUrl() {
        return this.rmiUrl;
    }

    @Deprecated
    public void setRmiUrl(String rmiUrl) {
        this.rmiUrl = rmiUrl == null ? "" : rmiUrl;
    }

    public String getSasifyTableNames() {
        return this.sasifyTableNames;
    }

    public void setSasifyTableNames(String sasifyTableNames) {
        this.sasifyTableNames = sasifyTableNames == null ? "default" : sasifyTableNames;
    }

    public String getUndoPolicyNone() {
        return this.undoPolicyNone;
    }

    public void setUndoPolicyNone(String undoPolicyNone) {
        this.undoPolicyNone = undoPolicyNone == null ? "true" : undoPolicyNone;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? "" : userName;
    }

    public String getUseSSPI() {
        return this.useSSPI;
    }

    public void setUseSSPI(String useSSPI) {
        this.useSSPI = useSSPI == null ? "none" : useSSPI;
    }

    private Properties generateProperties() {
        Properties p = new Properties();
        p.setProperty("userName", this.userName);
        p.setProperty("password", this.password);
        p.setProperty("applyFormats", this.applyFormats);
        p.setProperty("coerceNumericTypes", this.coerceNumericTypes);
        p.setProperty("dbms", this.dbms);
        p.setProperty("dbmsOptions", this.dbmsOptions);
        p.setProperty("encryptionAlgorithms", this.encryptionAlgorithms);
        p.setProperty("encryptionContent", this.encryptionContent);
        p.setProperty("encryptionPolicy", this.encryptionPolicy);
        p.setProperty("librefs", this.librefs);
        p.setProperty("remarks", this.remarks);
        p.setProperty("rmiurl", this.rmiUrl);
        p.setProperty("sasifytablenames", this.sasifyTableNames);
        p.setProperty("undoPolicyNone", this.undoPolicyNone);
        p.setProperty("usesspi", this.useSSPI);
        return p;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        String url = serverUrl;
        int qi = url.indexOf("?");
        if (qi >= 0) {
            String tu;
            String query = url.substring(++qi, url.length());
            url = tu = url.substring(0, qi - 1);
            StringTokenizer pairOff = new StringTokenizer(query, "&", false);
            while (pairOff.hasMoreTokens()) {
                String pair = pairOff.nextToken();
                char last = pair.charAt(pair.length() - 1);
                if (last == '\\') {
                    String realPair;
                    pair = realPair = pair.substring(0, pair.length() - 1) + "&" + pairOff.nextToken();
                }
                int pi = pair.indexOf("=");
                String propN = pair.substring(0, pi);
                String propV = pair.substring(pi + 1, pair.length());
                this.setProperty(propN, propV);
            }
        }
        this.serverUrl = url;
    }

    public String getSpn() {
        return this.spn;
    }

    public void setSpn(String spn) {
        this.spn = spn == null ? "" : spn;
    }

    public void setServerName(String s) {
        this.serverName = s;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setPortNumber(int i) {
        this.portNumber = i;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setSegmentLength(int i) {
        this.segmentLength = i;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    private void setProperty(String x, String y) {
        if (x.equalsIgnoreCase("userName") || x.equalsIgnoreCase("user")) {
            this.setUserName(y);
        } else if (x.equalsIgnoreCase("password")) {
            this.setPassword(y);
        } else if (x.equalsIgnoreCase("dbms")) {
            this.setDbms(y);
        } else if (x.equalsIgnoreCase("dbmsOptions")) {
            this.setDbmsOptions(y);
        } else if (x.equalsIgnoreCase("remarks")) {
            this.setRemarks(y);
        } else if (x.equalsIgnoreCase("undoPolicyNone")) {
            this.setUndoPolicyNone(y);
        } else if (x.equalsIgnoreCase("librefs")) {
            this.setLibrefs(y);
        } else if (x.equalsIgnoreCase("encryptionPolicy")) {
            this.setEncryptionPolicy(y);
        } else if (x.equalsIgnoreCase("encryptionContent")) {
            this.setEncryptionContent(y);
        } else if (x.equalsIgnoreCase("encryptionAlgorithms")) {
            this.setEncryptionAlgorithms(y);
        } else if (x.equalsIgnoreCase("applyFormats")) {
            this.setApplyFormats(y);
        } else if (x.equalsIgnoreCase("rmiUrl")) {
            this.setRmiUrl(y);
        } else if (x.equalsIgnoreCase("sasifyTableNames")) {
            this.setSasifyTableNames(y);
        } else if (x.equalsIgnoreCase("coerceNumericTypes")) {
            this.setCoerceNumericTypes(y);
        } else if (x.equalsIgnoreCase("useSSPI")) {
            this.setUseSSPI(y);
        } else if (x.equalsIgnoreCase("spn")) {
            this.setSpn(y);
        } else if (x.equalsIgnoreCase("segmentLength")) {
            this.setSegmentLength(Integer.parseInt(y));
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }
}

