/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;

@SASScope
public final class ProtocolVersion {
    public static final byte CURRENT_MAJOR = 2;
    public static final byte CURRENT_MINOR = 0;
    protected static final ProtocolVersion VERSION_01_00 = new ProtocolVersion(1, 0);
    protected static final ProtocolVersion VERSION_02_00 = new ProtocolVersion(2, 0);
    protected static final ProtocolVersion VERSION_CURRENT = ProtocolVersion.fromInt((byte)2, (byte)0);
    private byte pvMajor;
    private byte pvMinor;

    private ProtocolVersion(byte major, byte minor) {
        this.pvMajor = major;
        this.pvMinor = minor;
    }

    public String toString() {
        return Integer.toString(this.pvMajor) + "." + Integer.toString(this.pvMinor);
    }

    protected static ProtocolVersion fromInt(byte major) {
        return ProtocolVersion.fromInt(major, (byte)0);
    }

    protected static ProtocolVersion fromInt(byte major, byte minor) {
        switch (major) {
            case 2: {
                if (minor != 0) {
                    throw new IllegalArgumentException("minor: " + minor);
                }
                return VERSION_02_00;
            }
            case 1: {
                if (minor != 0) {
                    throw new IllegalArgumentException("minor: " + minor);
                }
                return VERSION_01_00;
            }
        }
        throw new IllegalArgumentException("major: " + major + " minor: " + minor);
    }

    protected byte getMajor() {
        return this.pvMajor;
    }

    protected byte getMinor() {
        return this.pvMinor;
    }
}

