/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.AuthenticationTicketFactory;
import com.sas.iom.orb.ConnectionContextInterface;
import com.sas.iom.orb.ORBBase;
import com.sas.iom.orb.SASURI;
import com.sas.iom.orb.SelectionHandlerInterface;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.SelectionHubActivation;
import com.sas.iom.orb.SelectionHubKey;
import com.sas.iom.orb.TrackedResourceInterface;
import com.sas.iom.orb.WorkInterface;
import com.sas.iom.orb.brg.BufferManager;
import com.sas.iom.orb.brg.Daemon;
import com.sas.iom.orb.brg.Engine;
import com.sas.iom.orb.brg.ORBImpl;
import com.sas.iom.orb.brg.ProtocolVersion;
import com.sas.iom.orb.brg.SecurityPackageBase;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.LoginContext;

@SASScope
public final class Conversation
implements SelectionHandlerInterface,
TrackedResourceInterface,
WorkInterface,
ConnectionContextInterface {
    private ORBImpl _orb;
    private Map _options;
    private SASURI _uri;
    private Daemon _daemon;
    private ProtocolVersion _protocolVersion;
    private Engine _engine;
    private boolean _redirected;
    private String[] _algArray;
    private int _algArrayIndex;
    private boolean _artificialAlg;
    private int _flowState;
    private SocketChannel _channel;
    private SelectionHub _hub;
    private SelectionHubActivation _hubActivation;
    private int _replyID;
    private int _objectID;
    private Crypto _crypto;
    private CipherInterface _cipher;
    private int _conversationID;
    private String _encoding;
    private CharsetEncoder _encoder;
    private CharsetDecoder _decoder;
    private List _packetList;
    private List _requestList;
    private List _replyList;
    private IOException _fatalException;
    private Map _remoteMap;
    private Map _localMap;
    private boolean _force0100;
    private boolean _peerClosed;
    private boolean _sasDateTime;
    private boolean _columnMajor;
    private boolean _pcMiss;
    private SecurityPackageBase _securityPackage;
    private String _normDomain;
    private String _normUserName;
    private BufferManager _bufferManager;
    private SocketChannel _redirectingChannel;
    private LoginContext _loginContext;
    private Process _sasProcess;
    private boolean _destroySasProcess;
    private boolean _forcingPlainTextRead;
    private URL[] _proxyArray;
    private int _proxyArrayIndex;
    private AuthenticationTicketFactory _authTicketFactory;
    private boolean _connectWithSSL;

    protected Conversation(ORBImpl orb, SelectionHub hub, SASURI uri) {
        this(orb, hub);
        this.initClient(uri);
    }

    protected Conversation(ORBImpl orb, SelectionHub hub, Daemon daemon, SocketChannel channel) {
        this(orb, hub);
        this.initServer(daemon, channel);
    }

    private Conversation(ORBImpl orb, SelectionHub hub) {
        this._orb = orb;
        this._hub = hub != null ? hub : SelectionHub.getInstance();
        this._requestList = new LinkedList();
        this._replyList = new LinkedList();
        this._packetList = new LinkedList();
        this._remoteMap = new HashMap();
        this._localMap = new HashMap();
    }

    @Override
    public void handleSelection(SelectionHubKey hubKey) {
        this._engine.handleSelection(this, hubKey);
    }

    @Override
    public void handleException(SelectionHubKey hubKey, IOException hubEx) {
        this._engine.handleException(this, hubKey, hubEx);
    }

    @Override
    public void shutdown(boolean waitForCompletion) {
        if (this._engine != null) {
            this._engine.term(this, waitForCompletion);
        }
    }

    @Override
    public void run() {
        this._engine.listen(this);
    }

    @Override
    public void release() {
    }

    @Override
    public Locale getLocale() {
        return (Locale)this._options.get("locale");
    }

    @Override
    public ORBBase getORBBase() {
        return this._orb;
    }

    protected void initClient(SASURI uri) {
        this._uri = uri;
        this._options = uri.getAttributesForScheme("BRIDGE");
    }

    protected void initServer(Daemon daemon, SocketChannel channel) {
        this._daemon = daemon;
        this._channel = channel;
        this._options = new HashMap(daemon.getOptions());
    }

    protected ORBImpl getORB() {
        return this._orb;
    }

    protected Map getOptions() {
        return this._options;
    }

    protected Object getOption(Object key) {
        return this._options != null ? this._options.get(key) : null;
    }

    protected SASURI getURI() {
        return this._uri;
    }

    protected SASURI getNegotiatedURI(String scheme, String[] omitAttrArr) {
        HashMap options = null;
        if (omitAttrArr != null && omitAttrArr.length > 0) {
            options = new HashMap(this._options);
            for (String omitAttr : omitAttrArr) {
                options.remove(omitAttr);
            }
        } else {
            options = this._options;
        }
        SASURI brgUri = new SASURI("BRIDGE", options);
        SASURI uri = null;
        if ("BRIDGE".equals(scheme)) {
            uri = brgUri;
        } else {
            Map attrMap = brgUri.getAttributes();
            uri = new SASURI(scheme, attrMap);
        }
        return uri;
    }

    protected Daemon getDaemon() {
        return this._daemon;
    }

    protected boolean isServer() {
        return this._uri == null;
    }

    protected ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    protected void setProtocolVersion(ProtocolVersion protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    protected Engine getEngine() {
        return this._engine;
    }

    protected void setEngine(Engine e) {
        this._engine = e;
    }

    protected String getHost() {
        return (String)this._options.get("host");
    }

    protected void setHost(String host) {
        Object hostN = SASURI.normalizeAttribute("host", host);
        SASURI.updateAttribute("host", hostN, this._options);
    }

    protected int getPort() {
        Integer port = (Integer)this._options.get("port");
        return port != null ? port : 0;
    }

    protected void setPort(int port) {
        Object portN = SASURI.normalizeAttribute("port", port);
        SASURI.updateAttribute("port", portN, this._options);
    }

    protected byte getTranscodingPreference() {
        String transcodingPreference = (String)this._options.get("transcodingpreference");
        return "client".equals(transcodingPreference) ? (byte)0 : 1;
    }

    protected void setTranscodingPreference(byte transcodingPreference) {
        String tp = transcodingPreference == 0 ? "client" : "server";
        SASURI.updateAttribute("transcodingpreference", tp, this._options);
    }

    protected boolean isRedirected() {
        return this._redirected;
    }

    protected void setRedirected(boolean redirected) {
        this._redirected = redirected;
    }

    protected String getEncryptionPolicy() {
        return (String)this._options.get("encryptionpolicy");
    }

    protected void setEncryptionPolicy(String encryptionPolicy) {
        Object encryptionPolicyN = SASURI.normalizeAttribute("encryptionpolicy", encryptionPolicy);
        SASURI.updateAttribute("encryptionpolicy", encryptionPolicyN, this._options);
    }

    protected byte getEncryptionLevel() {
        String encryptionContent;
        String encryptionPolicy = this.getEncryptionPolicy();
        int encryptionLevel = 0;
        encryptionLevel = encryptionPolicy == null || "none".equals(encryptionPolicy) ? 0 : ((encryptionContent = (String)this._options.get("encryptioncontent")) == null || "authentication".equals(encryptionContent) ? 1 : 2);
        return (byte)encryptionLevel;
    }

    protected void setEncryptionLevel(byte encryptionLevel) {
        if (encryptionLevel == 0) {
            SASURI.updateAttribute("encryptionpolicy", "none", this._options);
            SASURI.updateAttribute("encryptioncontent", null, this._options);
        } else {
            SASURI.updateAttribute("encryptionpolicy", "required", this._options);
            String encryptionContent = encryptionLevel == 1 ? "authentication" : "all";
            SASURI.updateAttribute("encryptioncontent", encryptionContent, this._options);
        }
    }

    protected String getEncryptionAlgorithms() {
        return (String)this._options.get("encryptionalgorithms");
    }

    protected void setEncryptionAlgorithms(String encryptionAlgorithms) {
        Object encryptionAlgorithmsN = SASURI.normalizeAttribute("encryptionalgorithms", encryptionAlgorithms);
        SASURI.updateAttribute("encryptionalgorithms", encryptionAlgorithmsN, this._options);
    }

    protected String[] getAlgArray() {
        return this._algArray;
    }

    protected void setAlgArray(String[] algArray) {
        this._algArray = algArray;
    }

    protected int getAlgArrayIndex() {
        return this._algArrayIndex;
    }

    protected void setAlgArrayIndex(int algArrayIndex) {
        this._algArrayIndex = algArrayIndex;
    }

    protected boolean isArtificialAlg() {
        return this._artificialAlg;
    }

    protected void setArtificialAlg(boolean artificialAlg) {
        this._artificialAlg = artificialAlg;
    }

    protected String getServerName() {
        return (String)this._options.get("servername");
    }

    protected void setServerName(String serverName) {
        Object serverNameN = SASURI.normalizeAttribute("servername", serverName);
        SASURI.updateAttribute("servername", serverNameN, this._options);
    }

    protected String getPassword() {
        return (String)this._options.get("password");
    }

    protected String getUserName() {
        return (String)this._options.get("username");
    }

    protected void setPassword(String password) {
        Object passwordN = SASURI.normalizeAttribute("password", password);
        SASURI.updateAttribute("password", passwordN, this._options);
    }

    protected void setUserName(String userName) {
        Object userNameN = SASURI.normalizeAttribute("username", userName);
        SASURI.updateAttribute("username", userNameN, this._options);
    }

    protected int getFlowState() {
        return this._flowState;
    }

    protected void setFlowState(int flowState) {
        this._flowState = flowState;
    }

    protected SocketChannel getChannel() {
        return this._channel;
    }

    protected void setChannel(SocketChannel channel) {
        this._channel = channel;
    }

    protected void setHub(SelectionHub hub) {
        this._hub = hub;
    }

    protected SelectionHub getHub() {
        return this._hub;
    }

    protected void setHubActivation(SelectionHubActivation hubActivation) {
        this._hubActivation = hubActivation;
    }

    protected SelectionHubActivation getHubActivation() {
        return this._hubActivation;
    }

    protected synchronized int getReplyID() {
        int replyID = this._replyID++;
        if (this._replyID < 0) {
            this._replyID = 0;
        }
        return replyID;
    }

    protected synchronized int getObjectID() {
        if (this._objectID == Integer.MAX_VALUE) {
            this._objectID = 0;
        }
        return ++this._objectID;
    }

    protected Crypto getCrypto() {
        return this._crypto;
    }

    protected void setCrypto(Crypto crypto) {
        this._crypto = crypto;
    }

    protected CipherInterface getCipher() {
        return this._cipher;
    }

    protected void setCipher(CipherInterface cipher) {
        this._cipher = cipher;
    }

    protected int getConversationID() {
        return this._conversationID;
    }

    protected void setConversationID(int conversationID) {
        this._conversationID = conversationID;
    }

    protected String getEncoding() {
        return this._encoding;
    }

    protected void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    protected CharsetEncoder getEncoder() {
        return this._encoder;
    }

    protected void setEncoder(CharsetEncoder encoder) {
        this._encoder = encoder;
    }

    protected CharsetDecoder getDecoder() {
        return this._decoder;
    }

    protected void setDecoder(CharsetDecoder decoder) {
        this._decoder = decoder;
    }

    protected List getPacketList() {
        return this._packetList;
    }

    protected List getRequestList() {
        return this._requestList;
    }

    protected List getReplyList() {
        return this._replyList;
    }

    protected IOException getFatalException() {
        return this._fatalException;
    }

    protected void setFatalException(IOException fatalException) {
        this._fatalException = fatalException;
    }

    protected String getClassID() {
        return (String)this._options.get("classfactory");
    }

    protected void setClassID(String classID) {
        Object classIDN = SASURI.normalizeAttribute("classfactory", classID);
        SASURI.updateAttribute("classfactory", classIDN, this._options);
    }

    protected String getClassName() {
        return (String)this._options.get("classname");
    }

    protected void setClassName(String className) {
        Object classNameN = SASURI.normalizeAttribute("classname", className);
        SASURI.updateAttribute("classname", classNameN, this._options);
    }

    protected Map getLocalMap() {
        return this._localMap;
    }

    protected Map getRemoteMap() {
        return this._remoteMap;
    }

    protected void setLocale(Locale locale) {
        Object localeN = SASURI.normalizeAttribute("locale", locale);
        SASURI.updateAttribute("locale", localeN, this._options);
    }

    protected boolean isForce0100() {
        return this._force0100;
    }

    protected void setForce0100(boolean force0100) {
        this._force0100 = force0100;
    }

    protected void setPeerClosed(boolean peerClosed) {
        this._peerClosed = peerClosed;
    }

    protected boolean isPeerClosed() {
        return this._peerClosed;
    }

    protected void setSASDateTime(boolean sasDateTime) {
        this._sasDateTime = sasDateTime;
    }

    protected boolean isSASDateTime() {
        return this._sasDateTime;
    }

    protected void setColumnMajor(boolean columnMajor) {
        this._columnMajor = columnMajor;
    }

    protected boolean isColumnMajor() {
        return this._columnMajor;
    }

    protected void setPCMiss(boolean pcMiss) {
        this._pcMiss = pcMiss;
    }

    protected boolean isPCMiss() {
        return this._pcMiss;
    }

    protected String getSecurityPackageName() {
        return (String)this._options.get("securitypackage");
    }

    protected void setSecurityPackageName(String securityPackageName) {
        Object securityPackageNameN = SASURI.normalizeAttribute("securitypackage", securityPackageName);
        SASURI.updateAttribute("securitypackage", securityPackageNameN, this._options);
    }

    protected String getSPN() {
        return (String)this._options.get("spn");
    }

    protected void setSPN(String spn) {
        Object spnN = SASURI.normalizeAttribute("spn", spn);
        SASURI.updateAttribute("spn", spnN, this._options);
    }

    protected SecurityPackageBase getSecurityPackage() {
        return this._securityPackage;
    }

    protected void setSecurityPackage(SecurityPackageBase securityPackage) {
        this._securityPackage = securityPackage;
    }

    protected String getSecurityPackageList() {
        return (String)this._options.get("securitypackagelist");
    }

    protected void setSecurityPackageList(String securityPackageList) {
        Object securityPackageListN = SASURI.normalizeAttribute("securitypackagelist", securityPackageList);
        SASURI.updateAttribute("securitypackagelist", securityPackageListN, this._options);
    }

    protected String getNormDomain() {
        return this._normDomain;
    }

    protected void setNormDomain(String normDomain) {
        this._normDomain = normDomain;
    }

    protected String getNormUserName() {
        return this._normUserName;
    }

    protected void setNormUserName(String normUserName) {
        this._normUserName = normUserName;
    }

    protected BufferManager getBufferManager() {
        return this._bufferManager;
    }

    protected void setBufferManager(BufferManager bufferManager) {
        this._bufferManager = bufferManager;
    }

    protected SocketChannel getRedirectingChannel() {
        return this._redirectingChannel;
    }

    protected void setRedirectingChannel(SocketChannel redirectingChannel) {
        this._redirectingChannel = redirectingChannel;
    }

    protected boolean isTrustedPeer() {
        Boolean trustedSAS = (Boolean)this._options.get("trustedsas");
        return trustedSAS != null && trustedSAS != false;
    }

    protected void setTrustedPeer(boolean trustedPeer) {
        Object trustedPeerN = SASURI.normalizeAttribute("trustedsas", trustedPeer);
        SASURI.updateAttribute("trustedsas", trustedPeerN, this._options);
    }

    protected String getExternalID() {
        return (String)this._options.get("connectionid");
    }

    protected void setExternalID(String externalID) {
        Object externalIDN = SASURI.normalizeAttribute("connectionid", externalID);
        SASURI.updateAttribute("connectionid", externalIDN, this._options);
    }

    protected String getSVID() {
        return (String)this._options.get("svid");
    }

    protected void setSVID(String svid) {
        Object svidN = SASURI.normalizeAttribute("svid", svid);
        SASURI.updateAttribute("svid", svidN, this._options);
    }

    protected void setLoginContext(LoginContext loginContext) {
        this._loginContext = loginContext;
    }

    protected LoginContext getLoginContext() {
        return this._loginContext;
    }

    protected void setZeroConfig(boolean zeroConfig) {
        Object zeroConfigN = SASURI.normalizeAttribute("zeroconfig", zeroConfig);
        SASURI.updateAttribute("zeroconfig", zeroConfigN, this._options);
    }

    protected boolean isZeroConfig() {
        Boolean zeroConfig = (Boolean)this._options.get("zeroconfig");
        return zeroConfig != null && zeroConfig != false;
    }

    protected void setSasProcess(Process sasProcess) {
        this._sasProcess = sasProcess;
    }

    protected Process getSasProcess() {
        return this._sasProcess;
    }

    protected void setDestroySasProcess(boolean destroySasProcess) {
        this._destroySasProcess = destroySasProcess;
    }

    protected boolean isDestroySasProcess() {
        return this._destroySasProcess;
    }

    protected void setApplicationName(String applicationName) {
        Object applicationNameN = SASURI.normalizeAttribute("applicationname", applicationName);
        SASURI.updateAttribute("applicationname", applicationNameN, this._options);
    }

    protected String getApplicationName() {
        return (String)this._options.get("applicationname");
    }

    protected void setSasCommand(String sasCommand) {
        Object sasCommandN = SASURI.normalizeAttribute("sascommand", sasCommand);
        SASURI.updateAttribute("sascommand", sasCommandN, this._options);
    }

    protected String getSasCommand() {
        return (String)this._options.get("sascommand");
    }

    protected void setForcingPlainTextRead(boolean forcingPlainTextRead) {
        this._forcingPlainTextRead = forcingPlainTextRead;
    }

    protected boolean isForcingPlainTextRead() {
        return this._forcingPlainTextRead;
    }

    protected void setProxyArray(InetSocketAddress[] proxyArray) {
    }

    protected InetSocketAddress[] getProxyArray() {
        return null;
    }

    protected void setProxyUrlArray(URL[] proxyArray) {
        this._proxyArray = proxyArray;
    }

    protected URL[] getProxyUrlArray() {
        return this._proxyArray;
    }

    protected void setProxyArrayIndex(int proxyArrayIndex) {
        this._proxyArrayIndex = proxyArrayIndex;
    }

    protected int getProxyArrayIndex() {
        return this._proxyArrayIndex;
    }

    protected void setAuthenticationTicketFactory(AuthenticationTicketFactory authTicketFactory) {
        this._authTicketFactory = authTicketFactory;
    }

    protected AuthenticationTicketFactory getAuthenticationTicketFactory() {
        return this._authTicketFactory;
    }

    protected void setConnectWithSSL(boolean connectWithSSL) {
        this._connectWithSSL = connectWithSSL;
    }

    protected boolean isConnectWithSSL() {
        return this._connectWithSSL;
    }
}

