/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.RB;
import com.sas.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

@SASScope(value="ALL")
public class Util {
    public static final String RB_KEY = "Util.";
    private static long commandCount;
    public static boolean tracing;
    public static final PrintStream printStream;
    public static PrintWriter printWriter;
    private static ResourceBundle _commonResourceBundle;
    private static Boolean qAccess;
    public static String JVM_VENDOR_SUN_MICROSYSTEMS;
    public static String JVM_VENDOR_NETSCAPE_COMMUNICATIONS;
    public static String JVM_VENDOR_MICROSOFT;
    public static String JVM_VENDOR_OTHER;
    private static String _vendor;
    public static String OS_SUN_MICROSYSTEMS_SOLARIS;
    public static String OS_MICROSOFT_WINDOWS;
    public static String OS_OTHER;
    private static String _opSys;
    private static String localeListDelimiter;
    private static Locale defaultLocale;

    private Util() {
    }

    public static final boolean equal(Object a, Object b) {
        return a == b || a != null && b != null && (a.getClass().isArray() && b.getClass().isArray() ? Util.arrayEqual(a, b) : a.equals(b));
    }

    public static final boolean unequal(Object a, Object b) {
        return !Util.equal(a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean equal(Vector v1, Vector v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null || v1.size() != v2.size()) {
            return false;
        }
        Vector vector = v1;
        synchronized (vector) {
            Vector vector2 = v2;
            synchronized (vector2) {
                int v1Len = v1.size();
                for (int i = 0; i < v1Len; ++i) {
                    Object o2;
                    Object o1 = v1.elementAt(i);
                    if (!Util.unequal(o1, o2 = v2.elementAt(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static final boolean equal(Enumeration e1, Enumeration e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        while (e1.hasMoreElements() && e2.hasMoreElements()) {
            Object b;
            Object a = e1.nextElement();
            if (!Util.unequal(a, b = e2.nextElement())) continue;
            return false;
        }
        return !e1.hasMoreElements() && !e2.hasMoreElements();
    }

    public static void flush() {
        if (!tracing) {
            return;
        }
        Util.checkPW();
        printWriter.flush();
    }

    private static void checkPW() {
        if (printWriter == null && printStream != null) {
            printWriter = new PrintWriter(printStream);
        }
    }

    public static final void print(String message) {
        if (!tracing) {
            return;
        }
        Util.checkPW();
        printWriter.print(message);
        Util.flush();
    }

    public static final void println(String message) {
        if (!tracing) {
            return;
        }
        Util.checkPW();
        printWriter.println(message);
        Util.flush();
    }

    public static final void println() {
        if (!tracing) {
            return;
        }
        Util.checkPW();
        printWriter.println();
        Util.flush();
    }

    public static final void println(String pattern, Object arg0) {
        if (!tracing) {
            return;
        }
        printWriter.print(MessageFormat.format(pattern, arg0));
        Util.flush();
    }

    public static final void println(String pattern, Object arg0, Object arg1) {
        if (!tracing) {
            return;
        }
        printWriter.print(MessageFormat.format(pattern, arg0, arg1));
        Util.flush();
    }

    public static final void println(String pattern, Object arg0, Object arg1, Object arg2) {
        if (!tracing) {
            return;
        }
        printWriter.print(MessageFormat.format(pattern, arg0, arg1, arg2));
        Util.flush();
    }

    public static final void println(String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (!tracing) {
            return;
        }
        printWriter.print(MessageFormat.format(pattern, arg0, arg1, arg2, arg3));
        Util.flush();
    }

    public static final void println(String pattern, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (!tracing) {
            return;
        }
        printWriter.print(MessageFormat.format(pattern, arg0, arg1, arg2, arg3, arg4));
        Util.flush();
    }

    public static final void println(String pattern, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (!tracing) {
            return;
        }
        printWriter.print(MessageFormat.format(pattern, arg0, arg1, arg2, arg3, arg4, arg5));
        Util.flush();
    }

    public static long toMillis(Calendar calendar) {
        return calendar.getTime().getTime();
    }

    public static long millisUntil(Calendar calendar) {
        long currentTime = System.currentTimeMillis();
        return calendar.getTime().getTime() - currentTime;
    }

    public static String getCommonStringResource(String key) {
        return Util.getCommonResources().getString(key);
    }

    public static ResourceBundle getCommonResources() {
        if (_commonResourceBundle == null) {
            _commonResourceBundle = ResourceBundle.getBundle("com.sas.util.CommonResources");
        }
        return _commonResourceBundle;
    }

    public static Object copyArray(Object array) {
        return Util.copyArray(array, 0, Array.getLength(array));
    }

    public static Object copyArray(Object array, int start, int end) {
        Object newArray;
        block5: {
            newArray = null;
            Class<?> componentType = null;
            try {
                componentType = array.getClass().getComponentType();
                newArray = Array.newInstance(componentType, end - start);
                System.arraycopy(array, start, newArray, 0, end - start);
            }
            catch (NullPointerException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (componentType == null) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "notArray.ex.txt"));
                }
                int length = Array.getLength(array);
                if (start < 0 || start >= length) {
                    throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "index.ex.txt"), new Integer(start), new Integer(0), new Integer(length)));
                }
                if (end >= start && end < length) break block5;
                throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "index.ex.txt"), new Integer(end), new Integer(start), new Integer(length)));
            }
        }
        return newArray;
    }

    public static Object[] resizeArray(Object[] array, int newSize) {
        Object[] result = new Object[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(newSize, array.length));
        return result;
    }

    public static boolean arrayContains(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (!Util.equal(array[i], obj)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean arrayEqual(Object arrayA, Object arrayB) {
        if (arrayA == arrayB) {
            return true;
        }
        if (arrayA == null || arrayB == null) {
            return false;
        }
        Object object = arrayA;
        synchronized (object) {
            Object object2 = arrayB;
            synchronized (object2) {
                Object[] objectb;
                Object[] objecta;
                int length;
                Class<?> classComponentB;
                Class<?> classA = arrayA.getClass();
                Class<?> classB = arrayB.getClass();
                if (!classA.isArray() && !classB.isArray()) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "notArray.ex.txt"));
                }
                if (classA != classB) {
                    return false;
                }
                Class<?> classComponentA = classA.getComponentType();
                if (classComponentA != (classComponentB = classB.getComponentType())) {
                    return false;
                }
                if (classComponentA.isPrimitive()) {
                    if (classComponentA == Integer.TYPE) {
                        return Util.arrayEqual((int[])arrayA, (int[])arrayB);
                    }
                    if (classComponentA == Boolean.TYPE) {
                        return Util.arrayEqual((boolean[])arrayA, (boolean[])arrayB);
                    }
                    if (classComponentA == Character.TYPE) {
                        return Util.arrayEqual((char[])arrayA, (char[])arrayB);
                    }
                    if (classComponentA == Byte.TYPE) {
                        return Util.arrayEqual((byte[])arrayA, (byte[])arrayB);
                    }
                    if (classComponentA == Short.TYPE) {
                        return Util.arrayEqual((short[])arrayA, (short[])arrayB);
                    }
                    if (classComponentA == Long.TYPE) {
                        return Util.arrayEqual((long[])arrayA, (long[])arrayB);
                    }
                    if (classComponentA == Float.TYPE) {
                        return Util.arrayEqual((float[])arrayA, (float[])arrayB);
                    }
                    if (classComponentA == Double.TYPE) {
                        return Util.arrayEqual((double[])arrayA, (double[])arrayB);
                    }
                } else if (classComponentA.isArray() && classComponentB.isArray()) {
                    int lenB;
                    int lenA = Array.getLength(arrayA);
                    if (lenA != (lenB = Array.getLength(arrayB))) {
                        return false;
                    }
                    for (int i = 0; i < lenA; ++i) {
                        Object subB;
                        Object subA = Array.get(arrayA, i);
                        if (Util.arrayEqual(subA, subB = Array.get(arrayB, i))) continue;
                        return false;
                    }
                    return true;
                }
                if ((length = (objecta = (Object[])arrayA).length) != (objectb = (Object[])arrayB).length) {
                    return false;
                }
                for (int i = 0; i < length; ++i) {
                    if (!Util.unequal(objecta[i], objectb[i])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean arrayEqual(int[] intArrayA, int[] intArrayB) {
        if (intArrayA.length != intArrayB.length) {
            return false;
        }
        for (int i = intArrayA.length - 1; i >= 0; --i) {
            if (intArrayA[i] == intArrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayEqual(boolean[] booleanArrayA, boolean[] booleanArrayB) {
        if (booleanArrayA.length != booleanArrayB.length) {
            return false;
        }
        for (int i = booleanArrayA.length - 1; i >= 0; --i) {
            if (booleanArrayA[i] == booleanArrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayEqual(byte[] byteArrayA, byte[] byteArrayB) {
        if (byteArrayA.length != byteArrayB.length) {
            return false;
        }
        for (int i = byteArrayA.length - 1; i >= 0; --i) {
            if (byteArrayA[i] == byteArrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayEqual(char[] charArrayA, char[] charArrayB) {
        if (charArrayA.length != charArrayB.length) {
            return false;
        }
        for (int i = charArrayA.length - 1; i >= 0; --i) {
            if (charArrayA[i] == charArrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayEqual(short[] shortArrayA, short[] shortArrayB) {
        if (shortArrayA.length != shortArrayB.length) {
            return false;
        }
        for (int i = shortArrayA.length - 1; i >= 0; --i) {
            if (shortArrayA[i] == shortArrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayEqual(long[] longArrayA, long[] longArrayB) {
        if (longArrayA.length != longArrayB.length) {
            return false;
        }
        for (int i = longArrayA.length - 1; i >= 0; --i) {
            if (longArrayA[i] == longArrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayEqual(float[] floatArrayA, float[] floatArrayB) {
        if (floatArrayA.length != floatArrayB.length) {
            return false;
        }
        for (int i = floatArrayA.length - 1; i >= 0; --i) {
            if (floatArrayA[i] == floatArrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayEqual(double[] doubleArrayA, double[] doubleArrayB) {
        if (doubleArrayA.length != doubleArrayB.length) {
            return false;
        }
        for (int i = doubleArrayA.length - 1; i >= 0; --i) {
            if (doubleArrayA[i] == doubleArrayB[i]) continue;
            return false;
        }
        return true;
    }

    public static Throwable getTargetException(Throwable exception) {
        while (exception instanceof InvocationTargetException) {
            exception = ((InvocationTargetException)exception).getTargetException();
        }
        return exception;
    }

    public static boolean canAccessAwtEventQueue() {
        if (qAccess != null) {
            return qAccess;
        }
        qAccess = Boolean.TRUE;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkAwtEventQueueAccess();
            }
            catch (SecurityException t) {
                qAccess = Boolean.FALSE;
            }
        }
        return qAccess;
    }

    public static boolean JVMVendorIs(String vendor) {
        if (_vendor == null) {
            String vendorProp = System.getProperty("java.vendor").toUpperCase();
            _vendor = vendorProp.indexOf(JVM_VENDOR_SUN_MICROSYSTEMS) >= 0 ? JVM_VENDOR_SUN_MICROSYSTEMS : (vendorProp.indexOf(JVM_VENDOR_NETSCAPE_COMMUNICATIONS) >= 0 ? JVM_VENDOR_NETSCAPE_COMMUNICATIONS : (vendorProp.indexOf(JVM_VENDOR_MICROSOFT) >= 0 ? JVM_VENDOR_MICROSOFT : JVM_VENDOR_OTHER));
        }
        return _vendor == (vendor = vendor.toUpperCase()) || _vendor.indexOf(vendor) >= 0;
    }

    public static boolean JVMVendorIsMicrosoft() {
        return Util.JVMVendorIs(JVM_VENDOR_MICROSOFT);
    }

    public static boolean JVMVendorIsNetscape() {
        return Util.JVMVendorIs(JVM_VENDOR_NETSCAPE_COMMUNICATIONS);
    }

    public static boolean JVMVendorIsSunMicrosystems() {
        return Util.JVMVendorIs(JVM_VENDOR_SUN_MICROSYSTEMS);
    }

    public static boolean osTypeIs(String opSys) {
        if (_opSys == null) {
            try {
                String osProp = System.getProperty("os.name").toUpperCase();
                _opSys = osProp.indexOf(OS_SUN_MICROSYSTEMS_SOLARIS) >= 0 ? OS_SUN_MICROSYSTEMS_SOLARIS : (osProp.indexOf(OS_MICROSOFT_WINDOWS) >= 0 ? OS_MICROSOFT_WINDOWS : OS_OTHER);
            }
            catch (SecurityException se) {
                _opSys = "";
            }
        }
        return _opSys == (opSys = opSys.toUpperCase()) || _opSys.indexOf(opSys) >= 0;
    }

    public static boolean osTypeIsWindows() {
        return Util.osTypeIs(OS_MICROSOFT_WINDOWS);
    }

    public static boolean osTypeIsSolaris() {
        return Util.osTypeIs(OS_SUN_MICROSYSTEMS_SOLARIS);
    }

    public static String getListDelimiter() {
        Locale currentLocale = Locale.getDefault();
        if (localeListDelimiter == null || currentLocale != defaultLocale) {
            try {
                defaultLocale = currentLocale;
                _commonResourceBundle = null;
                localeListDelimiter = Util.getCommonResources().getString("Delimiter.txt");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (localeListDelimiter == null) {
            localeListDelimiter = ",";
        }
        return localeListDelimiter;
    }

    public static char getListDelimiterChar() {
        return Util.getListDelimiter().charAt(0);
    }

    public static String getStackTraceAsString(Throwable t, boolean includeMessage) {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream(1000);
        PrintStream stream = new PrintStream(baoStream);
        if (t == null) {
            t = new Throwable();
        }
        if (includeMessage) {
            stream.println(t.getMessage());
        }
        t.printStackTrace(stream);
        stream.close();
        return new String(baoStream.toByteArray());
    }

    public static String getClassDeclaration(Class classObj) {
        if (!classObj.isArray()) {
            return classObj.getName();
        }
        String arrayDimension = "";
        String className = classObj.getName();
        while (className.startsWith("[")) {
            arrayDimension = arrayDimension + "[]";
            className = className.substring(1);
        }
        if (className.length() == 1) {
            if (className.equals("I")) {
                className = "int";
            } else if (className.equals("B")) {
                className = "byte";
            } else if (className.equals("C")) {
                className = "char";
            } else if (className.equals("D")) {
                className = "double";
            } else if (className.equals("F")) {
                className = "float";
            } else if (className.equals("J")) {
                className = "long";
            } else if (className.equals("S")) {
                className = "short";
            } else if (className.equals("Z")) {
                className = "boolean";
            }
        } else {
            className = className.substring(1, className.length() - 1);
        }
        return className + arrayDimension;
    }

    public static synchronized long getNumber() {
        return commandCount++;
    }

    public static synchronized String getName(String name) {
        return name + Util.getNumber();
    }

    public static String createJavaIdentifier(String name) {
        if (name == null) {
            return name;
        }
        char[] chars = new char[]{'_'};
        String[] strings = new String[]{"__"};
        String newName = Strings.replace(name, chars, strings);
        StringBuffer tempBffr = new StringBuffer(newName);
        char start = tempBffr.charAt(0);
        if (Character.isDigit(start)) {
            tempBffr.insert(0, "_");
        } else if (!Character.isJavaIdentifierStart(start)) {
            tempBffr.replace(0, 1, "_" + Integer.toHexString(start));
        }
        for (int j = tempBffr.length() - 1; j >= 1; --j) {
            char c = tempBffr.charAt(j);
            if (Character.isJavaIdentifierPart(c)) continue;
            tempBffr.replace(j, j + 1, "_" + Integer.toHexString(c));
        }
        return tempBffr.toString();
    }

    @SASScope
    public static Collection andCollections(Collection collection1, Collection collection2) {
        ArrayList list = new ArrayList(collection1.size());
        for (Object value : collection1) {
            if (!collection2.contains(value) || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    @SASScope
    public static Collection orCollections(Collection collection1, Collection collection2) {
        ArrayList list = new ArrayList(collection1);
        for (Object value : collection2) {
            if (list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    static {
        tracing = false;
        printStream = System.err;
        printWriter = new PrintWriter(new OutputStreamWriter(System.err));
        JVM_VENDOR_SUN_MICROSYSTEMS = "SUN MICROSYSTEMS";
        JVM_VENDOR_NETSCAPE_COMMUNICATIONS = "NETSCAPE";
        JVM_VENDOR_MICROSOFT = "MICROSOFT";
        JVM_VENDOR_OTHER = "<<unknown>>";
        OS_SUN_MICROSYSTEMS_SOLARIS = "SOLARIS";
        OS_MICROSOFT_WINDOWS = "WINDOWS";
        OS_OTHER = "<<unknown>>";
    }
}

