/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

@SASScope
public class CalendarUtil {
    public static final String XML_TIMESTAMP_PATTERN_TO_MILLISECOND = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSS'Z'";
    public static final String XML_TIME_PATTERN = "HH':'mm':'ss'Z'";
    public static final String XML_TIMESTAMP_PATTERN_TO_SECOND = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'";
    public static final String XML_TIMESTAMP_PATTERN_NO_TIME = "yyyy'-'MM'-'dd'T'00':'00':'00'Z'";
    private static TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    private CalendarUtil() {
    }

    private static void setCalendarAndTimeZone(DateFormat formatter, TimeZone tz) {
        if (tz == null) {
            formatter.setTimeZone(gmtTimeZone);
        } else {
            formatter.setTimeZone(tz);
        }
        Calendar cal = formatter.getCalendar();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        formatter.setCalendar(cal);
    }

    public static final Date parseDateString(String input, String pattern) throws ParseException {
        return CalendarUtil.parseDateString(input, pattern, null);
    }

    public static final Date parseDateString(String input, String pattern, TimeZone tz) throws ParseException {
        return CalendarUtil.parseDateString(input, pattern, tz, false);
    }

    public static final Date parseDateString(String input, String pattern, boolean lenient) throws ParseException {
        return CalendarUtil.parseDateString(input, pattern, null, false);
    }

    public static final Date parseDateString(String input, String pattern, TimeZone tz, boolean lenient) throws ParseException {
        if (null == pattern) {
            pattern = XML_TIMESTAMP_PATTERN_TO_SECOND;
        }
        SimpleDateFormat _timestampParser = new SimpleDateFormat();
        _timestampParser.applyPattern(pattern);
        _timestampParser.setLenient(lenient);
        CalendarUtil.setCalendarAndTimeZone(_timestampParser, tz);
        return _timestampParser.parse(input);
    }

    public static String formatCalendar(Calendar calendar, String pattern) {
        return CalendarUtil.formatDate(calendar.getTime(), pattern);
    }

    public static final String formatDate(Date date, String pattern) {
        if (null == pattern) {
            pattern = XML_TIMESTAMP_PATTERN_TO_SECOND;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setLenient(false);
        CalendarUtil.setCalendarAndTimeZone(formatter, null);
        return formatter.format(date);
    }
}

