/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Version {
    static Manifest manifest = null;

    public static void main(String[] args) {
        System.out.println("Copyright (c) 1998-2007 by SAS Institute Inc., Cary, NC 27513");
        System.out.println("Class Library Version Info");
        Version.getManifest();
        if (manifest != null) {
            System.out.println("   Major Version: " + Version.getMajorVersion());
            System.out.println("   Minor Version: " + Version.getMinorVersion());
            System.out.println("   Micro Version: " + Version.getMicroVersion());
            System.out.println("   Build Date: " + Version.getBuildDate());
            System.out.println("   Build Number: " + Version.getBuildNumber());
            System.out.println("   Extra Information: " + Version.getExtraInfo());
        } else {
            System.out.println("   Unable to read manifest");
        }
    }

    public static String getVersion() {
        NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.US);
        numberFormatter.setMinimumIntegerDigits(3);
        return Version.getMajorVersion() + "." + Version.getMinorVersion() + "." + Version.getBuildDate() + "." + numberFormatter.format(Version.getBuildNumber());
    }

    public static String getFullVersion() {
        NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.US);
        numberFormatter.setMinimumIntegerDigits(3);
        StringBuffer buffer = new StringBuffer();
        buffer.append(Version.getMajorVersion() + ".");
        buffer.append(Version.getMinorVersion() + ".");
        buffer.append(Version.getMicroVersion() + ".");
        buffer.append(Version.getBuildDate() + ".");
        buffer.append(numberFormatter.format(Version.getBuildNumber()));
        String extraInfo = Version.getExtraInfo();
        if (extraInfo != null && extraInfo.length() > 0) {
            buffer.append(".");
            buffer.append(extraInfo);
        }
        return buffer.toString();
    }

    public static int getMajorVersion() {
        String version = Version.getManifestValue("Specification-Version");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        Integer value = new Integer(tokenizer.nextToken());
        return value;
    }

    public static int getMinorVersion() {
        String version = Version.getManifestValue("Specification-Version");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        tokenizer.nextToken();
        Integer value = new Integer(tokenizer.nextToken());
        return value;
    }

    public static int getMicroVersion() {
        String version = Version.getManifestValue("Specification-Version");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        tokenizer.nextToken();
        tokenizer.nextToken();
        Integer value = new Integer(tokenizer.nextToken());
        return value;
    }

    public static int getBuildNumber() {
        String version = Version.getManifestValue("Specification-Version");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        tokenizer.nextToken();
        tokenizer.nextToken();
        tokenizer.nextToken();
        Integer value = new Integer(tokenizer.nextToken());
        return value;
    }

    public static String getBuildDate() {
        return Version.getManifestValue("Implementation-Build-Date");
    }

    public static String getExtraInfo() {
        return "";
    }

    protected static String getManifestValue(String key) {
        Version.getManifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        return mainAttributes.getValue(key);
    }

    protected static void getManifest() {
        if (manifest != null) {
            return;
        }
        try {
            String fileProtocol = "file:/";
            URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return Version.class.getClassLoader().getResource("com/sas/Version.class");
                }
            });
            String fileURL = url.getFile();
            int start = fileURL.indexOf("file:/");
            if (start != -1) {
                start += "file:/".length();
                int end = fileURL.indexOf(33);
                if (end != -1) {
                    final String URL2 = fileURL = fileURL.substring(start, end);
                    JarFile jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                        public final Object run() {
                            try {
                                return new JarFile(URL2);
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                    });
                    manifest = jarFile.getManifest();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

