import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteSecretRequest, DeleteSecretResponse } from "../models/models_0";
import { deserializeAws_json1_1DeleteSecretCommand, serializeAws_json1_1DeleteSecretCommand, } from "../protocols/Aws_json1_1";
var DeleteSecretCommand = (function (_super) {
    __extends(DeleteSecretCommand, _super);
    function DeleteSecretCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteSecretCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "DeleteSecretCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteSecretRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteSecretResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteSecretCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1DeleteSecretCommand(input, context);
    };
    DeleteSecretCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1DeleteSecretCommand(output, context);
    };
    return DeleteSecretCommand;
}($Command));
export { DeleteSecretCommand };
