FIND_PACKAGE(CUDA REQUIRED)
ENABLE_LANGUAGE(CUDA)
ADD_DEFINITIONS(-DHAVE_CUDA=1)

FUNCTION(TARGET_SET_CUDA_OPTIONS target)
    SET_TARGET_PROPERTIES(${target} torch_quiver
                          PROPERTIES CUDA_ARCHITECTURES ${CUDA_ARCHITECTURES})
    TARGET_INCLUDE_DIRECTORIES(${target}
                               PRIVATE ${CUDA_TOOLKIT_ROOT_DIR}/include)
    TARGET_LINK_DIRECTORIES(${target} PRIVATE ${CUDA_TOOLKIT_ROOT_DIR}/lib64)
    TARGET_COMPILE_OPTIONS(
        ${target} PRIVATE $<$<COMPILE_LANGUAGE:CUDA>:--expt-extended-lambda>)
ENDFUNCTION()
