from django.db import models


class Product(models.Model):
    price = models.IntegerField(null=True)
    discounted_price = models.IntegerField(null=True)

    class Meta:
        required_db_features = {
            'supports_table_check_constraints',
        }
        constraints = [
            models.CheckConstraint(
                check=models.Q(price__gt=models.F('discounted_price')),
                name='price_gt_discounted_price',
            ),
            models.CheckConstraint(
                check=models.Q(price__gt=0),
                name='%(app_label)s_%(class)s_price_gt_0',
            ),
        ]


class UniqueConstraintProduct(models.Model):
    name = models.CharField(max_length=255)
    color = models.CharField(max_length=32, null=True)

    class Meta:
        constraints = [
            models.UniqueConstraint(fields=['name', 'color'], name='name_color_uniq'),
            models.UniqueConstraint(
                fields=['name'],
                name='name_without_color_uniq',
                condition=models.Q(color__isnull=True),
            ),
        ]


class AbstractModel(models.Model):
    age = models.IntegerField()

    class Meta:
        abstract = True
        required_db_features = {
            'supports_table_check_constraints',
        }
        constraints = [
            models.CheckConstraint(
                check=models.Q(age__gte=18),
                name='%(app_label)s_%(class)s_adult',
            ),
        ]


class ChildModel(AbstractModel):
    pass
