"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const index_1 = require("../lib/index");
const core_1 = require("@aws-cdk/core");
const assert_1 = require("@aws-cdk/assert");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
test('has valid config', () => {
    const mockApp = new core_1.App();
    const stack = new index_1.AlexaSkillStack(mockApp, {
        skillId: 'mock-1234567890',
        skillName: 'test-skill',
        codeAsset: aws_lambda_1.Code.fromAsset(__dirname + '/../lib'),
    });
    assert_1.expect(stack).to(assert_1.haveResource("AWS::S3::Bucket"));
    assert_1.expect(stack).to(assert_1.haveResource("AWS::Lambda::Function"));
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXgudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImluZGV4LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3Q0FBK0M7QUFDL0Msd0NBQW9DO0FBQ3BDLDRDQUFvRTtBQUNwRSxvREFBMkM7QUFFM0MsSUFBSSxDQUFDLGtCQUFrQixFQUFFLEdBQUcsRUFBRTtJQUMxQixNQUFNLE9BQU8sR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0lBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksdUJBQWUsQ0FBQyxPQUFPLEVBQUU7UUFDdkMsT0FBTyxFQUFFLGlCQUFpQjtRQUMxQixTQUFTLEVBQUUsWUFBWTtRQUN2QixTQUFTLEVBQUUsaUJBQUksQ0FBQyxTQUFTLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztLQUNuRCxDQUFDLENBQUM7SUFFSCxlQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ3JELGVBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMscUJBQVksQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7QUFFL0QsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBbGV4YVNraWxsU3RhY2sgfSBmcm9tICcuLi9saWIvaW5kZXgnO1xuaW1wb3J0IHsgQXBwIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBleHBlY3QgYXMgZXhwZWN0Q0RLLCBoYXZlUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9hc3NlcnQnO1xuaW1wb3J0IHsgQ29kZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuXG50ZXN0KCdoYXMgdmFsaWQgY29uZmlnJywgKCkgPT4ge1xuICAgIGNvbnN0IG1vY2tBcHAgPSBuZXcgQXBwKCk7XG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgQWxleGFTa2lsbFN0YWNrKG1vY2tBcHAsIHtcbiAgICAgICAgc2tpbGxJZDogJ21vY2stMTIzNDU2Nzg5MCcsXG4gICAgICAgIHNraWxsTmFtZTogJ3Rlc3Qtc2tpbGwnLFxuICAgICAgICBjb2RlQXNzZXQ6IENvZGUuZnJvbUFzc2V0KF9fZGlybmFtZSArICcvLi4vbGliJyksXG4gICAgfSk7XG5cbiAgICBleHBlY3RDREsoc3RhY2spLnRvKGhhdmVSZXNvdXJjZShcIkFXUzo6UzM6OkJ1Y2tldFwiKSk7XG4gICAgZXhwZWN0Q0RLKHN0YWNrKS50byhoYXZlUmVzb3VyY2UoXCJBV1M6OkxhbWJkYTo6RnVuY3Rpb25cIikpO1xuXG59KTsiXX0=