import { Code } from '@aws-cdk/aws-lambda';
import { App, Stack } from '@aws-cdk/core';
export interface AlexaSkillConfig {
    /** The Alexa Skill id */
    readonly skillId: string;
    /** The Alexa Skill name */
    readonly skillName: string;
    /** The code to use for the backend lambda */
    readonly codeAsset: Code;
    /** Environement variables for the Lambda function */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * The handler for the lambda function
     * @default dist/index.handler
     */
    readonly codeHandler?: string;
    /**
     * name of the user attribute for DynamoDB
     * @default id
     */
    readonly userAttribute?: string;
}
export declare class AlexaSkillStack extends Stack {
    constructor(parent: App, config: AlexaSkillConfig);
}
