import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHashicupsIngredientsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/d/ingredients#coffee_id DataHashicupsIngredients#coffee_id}
    */
    readonly coffeeId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/d/ingredients#id DataHashicupsIngredients#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataHashicupsIngredientsIngredients {
}
export declare function dataHashicupsIngredientsIngredientsToTerraform(struct?: DataHashicupsIngredientsIngredients): any;
export declare class DataHashicupsIngredientsIngredientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataHashicupsIngredientsIngredients | undefined;
    set internalValue(value: DataHashicupsIngredientsIngredients | undefined);
    get id(): number;
    get name(): string;
    get quantity(): number;
    get unit(): string;
}
export declare class DataHashicupsIngredientsIngredientsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataHashicupsIngredientsIngredientsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/hashicups/d/ingredients hashicups_ingredients}
*/
export declare class DataHashicupsIngredients extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hashicups_ingredients";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/hashicups/d/ingredients hashicups_ingredients} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHashicupsIngredientsConfig
    */
    constructor(scope: Construct, id: string, config: DataHashicupsIngredientsConfig);
    private _coffeeId?;
    get coffeeId(): number;
    set coffeeId(value: number);
    get coffeeIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingredients;
    get ingredients(): DataHashicupsIngredientsIngredientsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
