/*
    Returns a key that maps to a value in a given
    object. Defaults to the empty string if it
    cannot find anything.
*/
export function getKeyFromValue(object, value) {
    const key = Object.keys(object).find(key => object[key] === value);
    return key !== undefined ? key : '';
}
// Object.assign but works with nested objects
function recurseObjectAssign(target, source) {
    Object.getOwnPropertyNames(source).forEach((key) => {
        const sourceValue = source[key];
        const targetValue = target[key];
        // If source and target are both objects, we recurse
        if (typeof sourceValue === 'object' && typeof targetValue === 'object') {
            recurseObjectAssign(targetValue, sourceValue);
        }
        else {
            target[key] = sourceValue;
        }
    });
    return target;
}
/**
 * Given an object an a partial object, will update the object with the partial object.
 * Works with nested objects.
 */
export function updateObjectWithPartialObject(graphParams, update) {
    const newParams = JSON.parse(JSON.stringify(graphParams));
    recurseObjectAssign(newParams, update);
    return newParams;
}
//# sourceMappingURL=objects.js.map