// Copyright (c) Mito
import React from 'react';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import DropdownSectionSeperator from '../elements/DropdownSectionSeperator';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays the format options.
 */
const ToolbarFormatDropdown = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Dropdown, { display: props.uiState.currOpenToolbarDropdown === 'Format', closeDropdown: () => props.setUIState((prevUIState) => {
                // Only close this dropdown if it's actually the one that is open, to avoid race conditions
                if (prevUIState.currOpenToolbarDropdown === 'Format') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'large' },
            makeToolbarDropdownItem(props.actions[ActionEnum.Set_Dataframe_Format]),
            React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
            makeToolbarDropdownItem(props.actions[ActionEnum.Format_Number_Columns]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Precision_Decrease]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Precision_Increase]))));
};
export default ToolbarFormatDropdown;
//# sourceMappingURL=ToolbarFormatDropdown.js.map