// Copyright (c) Mito
import React from 'react';
import fscreen from 'fscreen';
import ToolbarButton from './ToolbarButton';
import { ToolbarButtonType } from './utils';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import { getColumnFormatDropdownItems } from '../../utils/format';
// Import CSS
import "../../../css/toolbar.css";
import ToolbarEditDropdown from './ToolbarEditDropdown';
import ToolbarDataframesDropdown from './ToolbarDataframesDropdown';
import ToolbarMenu from './ToolbarDropdownSelector';
import ToolbarColumnsDropdown from './ToolbarColumnsDropdown';
import ToolbarGraphsDropdown from './ToolbarGraphsDropdown';
import ToolbarViewDropdown from './ToolbarViewDropdown';
import ToolbarHelpDropdown from './ToolbarHelpDropdown';
import PlanButton from './PlanButton';
import ToolbarRowsDropdown from './ToolbarRowsDropdown.tsx';
import OpenOnboardingChecklist from './OpenChecklistButton';
import { isVariantB } from '../../utils/experiments';
import ToolbarFormatDropdown from './ToolbarFormatDropdown';
import { getSelectedNumberSeriesColumnIDs } from '../endo/selectionUtils';
const Toolbar = (props) => {
    return (React.createElement("div", { className: 'toolbar-container' },
        React.createElement("div", { className: 'toolbar-top' },
            React.createElement("div", { className: 'toolbar-top-left' },
                React.createElement(ToolbarMenu, { type: 'Edit', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarEditDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState })),
                React.createElement(ToolbarMenu, { type: 'Dataframes', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarDataframesDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState })),
                React.createElement(ToolbarMenu, { type: 'Columns', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarColumnsDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState, userProfile: props.userProfile })),
                React.createElement(ToolbarMenu, { type: 'Rows', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarRowsDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState })),
                React.createElement(ToolbarMenu, { type: 'Graphs', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarGraphsDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState })),
                React.createElement(ToolbarMenu, { type: 'Format', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarFormatDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState })),
                React.createElement(ToolbarMenu, { type: 'View', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarViewDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState })),
                React.createElement(ToolbarMenu, { type: 'Help', uiState: props.uiState, setUIState: props.setUIState },
                    React.createElement(ToolbarHelpDropdown, { actions: props.actions, uiState: props.uiState, setUIState: props.setUIState }))),
            React.createElement("div", { className: 'flexbox-row', style: { gap: '10px' } },
                React.createElement(OpenOnboardingChecklist, { userProfile: props.userProfile, setUIState: props.setUIState, mitoAPI: props.mitoAPI, analysisData: props.analysisData }),
                React.createElement(PlanButton, { userProfile: props.userProfile, setUIState: props.setUIState, mitoAPI: props.mitoAPI }))),
        React.createElement("div", { className: 'toolbar-top-bottom-seperator' }),
        React.createElement("div", { className: 'toolbar-bottom' },
            React.createElement("div", { className: 'toolbar-bottom-left-half' },
                React.createElement(ToolbarButton, { id: 'mito-undo-button' // NOTE: this is used to click the undo button in plugin.tsx
                    , toolbarButtonType: ToolbarButtonType.UNDO, action: props.actions[ActionEnum.Undo] }),
                React.createElement(ToolbarButton, { id: 'mito-redo-button' // NOTE: this is used to click the redo button in plugin.tsx
                    , toolbarButtonType: ToolbarButtonType.REDO, action: props.actions[ActionEnum.Redo] }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.CLEAR, action: props.actions[ActionEnum.Clear] }),
                React.createElement("div", { className: "toolbar-vertical-line" }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.IMPORT, action: props.actions[ActionEnum.Import], setEditorState: props.setEditorState }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.EXPORT, action: props.actions[ActionEnum.Export], setEditorState: props.setEditorState, disabledTooltip: isVariantB(props.analysisData) ? undefined : props.actions[ActionEnum.Export].isDisabled() }),
                React.createElement("div", { className: "toolbar-vertical-line" }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.ADD_COL, action: props.actions[ActionEnum.Add_Column], highlightToolbarButton: props.highlightAddColButton, setEditorState: props.setEditorState, disabledTooltip: isVariantB(props.analysisData) ? undefined : props.actions[ActionEnum.Add_Column].isDisabled() }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.DEL_COL, action: props.actions[ActionEnum.Delete_Column], setEditorState: props.setEditorState, disabledTooltip: isVariantB(props.analysisData) ? undefined : props.actions[ActionEnum.Delete_Column].isDisabled() }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.DTYPE, action: props.actions[ActionEnum.Change_Dtype], setEditorState: props.setEditorState, disabledTooltip: isVariantB(props.analysisData) ? undefined : props.actions[ActionEnum.Change_Dtype].isDisabled() }),
                React.createElement("div", { className: "toolbar-vertical-line" }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.LESS, action: props.actions[ActionEnum.Precision_Decrease], setEditorState: props.setEditorState, disabledTooltip: props.actions[ActionEnum.Precision_Decrease].isDisabled() }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.MORE, action: props.actions[ActionEnum.Precision_Increase], setEditorState: props.setEditorState, disabledTooltip: props.actions[ActionEnum.Precision_Increase].isDisabled() }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.FORMAT, action: props.actions[ActionEnum.Format_Number_Columns], setEditorState: props.setEditorState, disabledTooltip: isVariantB(props.analysisData) ? undefined : props.actions[ActionEnum.Format_Number_Columns].isDisabled() },
                    React.createElement(Dropdown, { display: props.uiState.displayFormatToolbarDropdown, closeDropdown: () => props.setUIState(prevUIState => {
                            return Object.assign(Object.assign({}, prevUIState), { displayFormatToolbarDropdown: false });
                        }) }, getColumnFormatDropdownItems(props.gridState.sheetIndex, props.sheetData, getSelectedNumberSeriesColumnIDs(props.gridState.selections, props.sheetData), props.mitoAPI))),
                React.createElement("div", { className: "toolbar-vertical-line" }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.PIVOT, action: props.actions[ActionEnum.Pivot], highlightToolbarButton: props.highlightPivotTableButton, setEditorState: props.setEditorState, disabledTooltip: isVariantB(props.analysisData) ? undefined : props.actions[ActionEnum.Pivot].isDisabled() }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.GRAPH, action: props.actions[ActionEnum.Graph], setEditorState: props.setEditorState, disabledTooltip: isVariantB(props.analysisData) ? undefined : props.actions[ActionEnum.Graph].isDisabled() })),
            React.createElement("div", { className: 'toolbar-bottom-right-half' },
                props.currStepIdx !== props.lastStepIndex &&
                    React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.CATCH_UP, action: props.actions[ActionEnum.Catch_Up] }),
                React.createElement(ToolbarButton, { toolbarButtonType: ToolbarButtonType.STEPS, action: props.actions[ActionEnum.Steps] }),
                React.createElement("div", { className: "toolbar-vertical-line" }),
                React.createElement(ToolbarButton, { toolbarButtonType: fscreen.fullscreenElement ? ToolbarButtonType.CLOSE_FULLSCREEN : ToolbarButtonType.OPEN_FULLSCREEN, action: props.actions[ActionEnum.Fullscreen] })))));
};
export default Toolbar;
//# sourceMappingURL=Toolbar.js.map