// Copyright (c) Mito
/*
    Each Taskpane has a type (included TaskpaneType.NONE, which is the type of _no taskpane_ (e.g. nothing is displayed)).

    If you want to be able to open a taskpane in Mito, then you need to add the type of this taskpane,
    as well as any __unique__ parameters it has, to this type.

    For example, if you create a new taskpane 'Dork' that takes a selectedSheetIndex as input, then you don't need to
    add a param to Dork here because the selectedSheetIndex is already stored in the Mito state. But if Dork takes a param
    timeOfOpen, which is not stored in the Mito state already, then you must add timeOfOpen to the params here.

    It would look like this:
        | {type: 'TaskpaneType.DORK', timeOfOpen: string}

    By adding any special params to the taskpane type we ensure that any time we create the taskpane, the special param
    is added to the state (this happens through the setCurrOpenTaskpane function.

    Then, when we are actually setting the taskpane component in getCurrOpenTaskpane, we're able to access the special param using
    this.state.currOpenTaskpane.timeOfOpen
*/
export var TaskpaneType;
(function (TaskpaneType) {
    TaskpaneType["CONTROL_PANEL"] = "control_panel";
    TaskpaneType["DOWNLOAD"] = "download";
    TaskpaneType["DROP_DUPLICATES"] = "drop_duplicates";
    TaskpaneType["GRAPH"] = "graph";
    TaskpaneType["IMPORT"] = "import";
    TaskpaneType["MERGE"] = "merge";
    TaskpaneType["CONCAT"] = "concat";
    TaskpaneType["NONE"] = "none";
    TaskpaneType["PIVOT"] = "pivot";
    TaskpaneType["STEPS"] = "steps";
    TaskpaneType["SPLIT_TEXT_TO_COLUMNS"] = "split_text_to_columns";
    TaskpaneType["UPGRADE_TO_PRO"] = "upgrade_to_pro";
    TaskpaneType["IMPORT_FIRST"] = "import_first";
    TaskpaneType["FILL_NA"] = "fill_na";
    TaskpaneType["MELT"] = "melt";
    TaskpaneType["SET_DATAFRAME_FORMAT"] = "set_dataframe_format";
    // AUTOGENERATED LINE: TASKPANETYPE (DO NOT DELETE)
})(TaskpaneType || (TaskpaneType = {}));
// AUTOGENERATED LINE: TASKPANEINFO (DO NOT DELETE)
/*
    EDITING_TASKPANES are taskpanes that update the sheet using overwriting
    and therefore should be closed when the user begins editing the sheet
    through some other method.
*/
export const EDITING_TASKPANES = [
    TaskpaneType.PIVOT,
    TaskpaneType.MERGE,
    TaskpaneType.CONCAT,
    TaskpaneType.DROP_DUPLICATES,
    TaskpaneType.IMPORT,
    TaskpaneType.DOWNLOAD,
    TaskpaneType.SPLIT_TEXT_TO_COLUMNS,
    TaskpaneType.FILL_NA,
    TaskpaneType.MELT,
    TaskpaneType.SET_DATAFRAME_FORMAT,
    // AUTOGENERATED LINE: EDITINGTASKPANE (DO NOT DELETE)
];
/**
 * Editing taskpanes where undo / redo should not close them, but rather
 * keep them open (e.g. so they can refresh params)
 *
 * TODO: remove this, once we make all of the taskpanes work with
 * undo and redo
 */
export const ALLOW_UNDO_REDO_EDITING_TASKPANES = [
    TaskpaneType.PIVOT,
    TaskpaneType.MERGE,
    TaskpaneType.CONCAT,
    TaskpaneType.DROP_DUPLICATES,
    TaskpaneType.IMPORT,
    TaskpaneType.SPLIT_TEXT_TO_COLUMNS,
    TaskpaneType.FILL_NA,
    TaskpaneType.MELT,
    TaskpaneType.SET_DATAFRAME_FORMAT,
    // AUTOGENERATED LINE: ALLOWUNDOREDOEDITINGTASKPANE (DO NOT DELETE)
];
//# sourceMappingURL=taskpanes.js.map