import React from 'react';
import { HEADER_TEXT_COLOR_DEFAULT } from '../../endo/ColumnHeader';
import { EVEN_ROW_TEXT_COLOR_DEFAULT, ODD_ROW_TEXT_COLOR_DEFAULT } from '../../endo/GridData';
import SuggestedStyle1Icon from '../../icons/SuggestedStyle1Icon';
import SuggestedStyle2Icon from '../../icons/SuggestedStyle2Icon';
import SuggestedStyle3Icon from '../../icons/SuggestedStyle3Icon';
import SuggestedStyle4Icon from '../../icons/SuggestedStyle4Icon';
import SuggestedStyle5Icon from '../../icons/SuggestedStyle5Icon';
import Col from '../../layout/Col';
import Row from '../../layout/Row';
const SuggestedStyles = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Row, null,
            React.createElement(Col, null,
                React.createElement("p", { className: 'text-header-3' }, "Suggested Styles"))),
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement("div", { onClick: () => {
                    // Just clearing out the data sets it to the default
                    props.updateDataframeFormatParams({
                        headers: { color: undefined, backgroundColor: undefined },
                        rows: { even: { color: undefined, backgroundColor: undefined }, odd: { color: undefined, backgroundColor: undefined } },
                        border: { borderStyle: undefined, borderColor: undefined }
                    });
                } },
                React.createElement(SuggestedStyle1Icon, null)),
            React.createElement("div", { onClick: () => {
                    props.updateDataframeFormatParams({
                        headers: {
                            color: HEADER_TEXT_COLOR_DEFAULT,
                            backgroundColor: '#9B9B9D'
                        },
                        rows: { even: { color: EVEN_ROW_TEXT_COLOR_DEFAULT, backgroundColor: undefined }, odd: { color: ODD_ROW_TEXT_COLOR_DEFAULT, backgroundColor: undefined } },
                        border: { borderStyle: undefined, borderColor: undefined }
                    });
                } },
                React.createElement(SuggestedStyle2Icon, null)),
            React.createElement("div", { onClick: () => {
                    props.updateDataframeFormatParams({
                        headers: {
                            color: '#FFFFFF',
                            backgroundColor: '#549D3A'
                        },
                        rows: { even: { color: EVEN_ROW_TEXT_COLOR_DEFAULT, backgroundColor: '#D0E3C9' }, odd: { color: ODD_ROW_TEXT_COLOR_DEFAULT, backgroundColor: undefined } },
                        border: { borderStyle: undefined, borderColor: undefined }
                    });
                } },
                React.createElement(SuggestedStyle3Icon, null)),
            React.createElement("div", { onClick: () => {
                    props.updateDataframeFormatParams({
                        headers: {
                            color: '#FFFFFF',
                            backgroundColor: '#4D73BE'
                        },
                        rows: { even: { color: EVEN_ROW_TEXT_COLOR_DEFAULT, backgroundColor: '#DAE1F0' }, odd: { color: ODD_ROW_TEXT_COLOR_DEFAULT, backgroundColor: undefined } },
                        border: { borderStyle: undefined, borderColor: undefined }
                    });
                } },
                React.createElement(SuggestedStyle4Icon, null)),
            React.createElement("div", { onClick: () => {
                    props.updateDataframeFormatParams({
                        headers: {
                            color: '#FFFFFF',
                            backgroundColor: '#8F1B15'
                        },
                        rows: { even: { color: EVEN_ROW_TEXT_COLOR_DEFAULT, backgroundColor: '#F0DADA' }, odd: { color: ODD_ROW_TEXT_COLOR_DEFAULT, backgroundColor: undefined } },
                        border: { borderStyle: undefined, borderColor: undefined }
                    });
                } },
                React.createElement(SuggestedStyle5Icon, null)))));
};
export default SuggestedStyles;
//# sourceMappingURL=SuggestedStyles.js.map