import React from "react";
import { StepType } from "../../../types";
import useLiveUpdatingParams from '../../../hooks/useLiveUpdatingParams';
import Select from '../../elements/Select';
import DropdownItem from '../../elements/DropdownItem';
import Col from '../../layout/Col';
import Row from '../../layout/Row';
import Spacer from '../../layout/Spacer';
import DefaultTaskpane from "../DefaultTaskpane/DefaultTaskpane";
import DefaultTaskpaneBody from "../DefaultTaskpane/DefaultTaskpaneBody";
import DefaultTaskpaneHeader from "../DefaultTaskpane/DefaultTaskpaneHeader";
import DefaultEmptyTaskpane from "../DefaultTaskpane/DefaultEmptyTaskpane";
import CollapsibleSection from "../../layout/CollapsibleSection";
import LabelAndColor from "../../../pro/graph/LabelAndColor";
import { updateObjectWithPartialObject } from "../../../utils/objects";
import { HEADER_BACKGROUND_COLOR_DEFAULT, HEADER_TEXT_COLOR_DEFAULT } from "../../endo/ColumnHeader";
import { EVEN_ROW_BACKGROUND_COLOR_DEFAULT, EVEN_ROW_TEXT_COLOR_DEFAULT, ODD_ROW_BACKGROUND_COLOR_DEFAULT, ODD_ROW_TEXT_COLOR_DEFAULT } from "../../endo/GridData";
import Tooltip from "../../elements/Tooltip";
import SuggestedStyles from "./SuggestedStyles";
import DataframeSelect from "../../elements/DataframeSelect";
const BORDER_COLOR_DEFAULT = '#FFFFFF';
export const getDefaultDataframeFormat = () => {
    return { columns: {}, headers: {}, rows: { even: {}, odd: {} }, border: {} };
};
const getDefaultParams = (sheetDataArray, sheetIndex) => {
    if (sheetDataArray.length === 0 || sheetDataArray[sheetIndex] === undefined) {
        return undefined;
    }
    return {
        sheet_index: sheetIndex,
        df_format: sheetDataArray[sheetIndex].dfFormat || getDefaultDataframeFormat(),
    };
};
/*
    This taskpane allows you to set dataframe format
*/
const SetDataframeFormatTaskpane = (props) => {
    const { params, setParams, startNewStep } = useLiveUpdatingParams(() => getDefaultParams(props.sheetDataArray, props.selectedSheetIndex), StepType.SetDataframeFormat, props.mitoAPI, props.analysisData, 50);
    const sheetFormat = (props.sheetDataArray[(params === null || params === void 0 ? void 0 : params.sheet_index) || 0] || {}).dfFormat;
    if (params === undefined || sheetFormat === undefined) {
        return React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState });
    }
    const updateDataframeFormatParams = (newParams) => {
        setParams(prevParams => {
            return updateObjectWithPartialObject(prevParams, { df_format: newParams });
        });
    };
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: "Color Dataframe", setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, { userProfile: props.userProfile, requiresPro: true, requiresProMessage: "Setting the dataframe format is a Mito Pro feature. Please upgrade to use this feature." },
            React.createElement(DataframeSelect, { sheetDataArray: props.sheetDataArray, sheetIndex: params.sheet_index, onChange: (newSheetIndex) => {
                    // First, we start a new step
                    startNewStep();
                    // Then, update the params
                    setParams(prevParams => {
                        const newParams = getDefaultParams(props.sheetDataArray, newSheetIndex);
                        if (newParams) {
                            return newParams;
                        }
                        return Object.assign(Object.assign({}, prevParams), { sheet_index: newSheetIndex });
                    });
                    // Then, we update the selected sheet index
                    props.setUIState(prevState => {
                        return Object.assign(Object.assign({}, prevState), { selectedSheetIndex: newSheetIndex });
                    });
                } }),
            React.createElement(SuggestedStyles, { updateDataframeFormatParams: updateDataframeFormatParams }),
            React.createElement(CollapsibleSection, { title: "Column Headers" },
                React.createElement(LabelAndColor, { label: 'Background Color', color: params.df_format.headers.backgroundColor || HEADER_BACKGROUND_COLOR_DEFAULT, onChange: (newColor) => {
                        return updateDataframeFormatParams({ headers: { backgroundColor: newColor } });
                    } }),
                React.createElement(LabelAndColor, { label: 'Text Color', color: params.df_format.headers.color || HEADER_TEXT_COLOR_DEFAULT, onChange: (newColor) => {
                        return updateDataframeFormatParams({ headers: { color: newColor } });
                    } })),
            React.createElement(Spacer, { px: 10 }),
            React.createElement(CollapsibleSection, { title: "Rows" },
                React.createElement(LabelAndColor, { label: 'Even Row: Background Color', color: params.df_format.rows.even.backgroundColor || EVEN_ROW_BACKGROUND_COLOR_DEFAULT, onChange: (newColor) => {
                        return updateDataframeFormatParams({ rows: { even: { backgroundColor: newColor } } });
                    } }),
                React.createElement(LabelAndColor, { label: 'Even Row: Text Color', color: params.df_format.rows.even.color || EVEN_ROW_TEXT_COLOR_DEFAULT, onChange: (newColor) => {
                        return updateDataframeFormatParams({ rows: { even: { color: newColor } } });
                    } }),
                React.createElement(LabelAndColor, { label: 'Odd Row: Background Color', color: params.df_format.rows.odd.backgroundColor || ODD_ROW_BACKGROUND_COLOR_DEFAULT, onChange: (newColor) => {
                        return updateDataframeFormatParams({ rows: { odd: { backgroundColor: newColor } } });
                    } }),
                React.createElement(LabelAndColor, { label: 'Odd Row: Text Color', color: params.df_format.rows.odd.color || ODD_ROW_TEXT_COLOR_DEFAULT, onChange: (newColor) => {
                        return updateDataframeFormatParams({ rows: { odd: { color: newColor } } });
                    } })),
            React.createElement(Spacer, { px: 10 }),
            React.createElement(CollapsibleSection, { title: "Dataframe Border" },
                React.createElement(Row, { justify: "space-between", align: "center" },
                    React.createElement(Col, null,
                        React.createElement(Row, { justify: "start", align: "center" },
                            React.createElement("p", null, "Border Style"),
                            React.createElement(Tooltip, { title: "The border line will be displayed when the dataframe styling object is printed out." })),
                        React.createElement(React.Fragment, null)),
                    React.createElement(Col, null),
                    React.createElement(Select, { value: params.df_format.border.borderStyle || 'none', width: 'medium', onChange: (newBorderStyle) => {
                            if (newBorderStyle === 'none') {
                                return updateDataframeFormatParams({ border: { borderStyle: undefined } });
                            }
                            return updateDataframeFormatParams({ border: { borderStyle: newBorderStyle } });
                        } },
                        React.createElement(DropdownItem, { title: "none" }),
                        React.createElement(DropdownItem, { title: "solid" }),
                        React.createElement(DropdownItem, { title: "dashed" }))),
                React.createElement(LabelAndColor, { label: 'Border Color', color: params.df_format.border.borderColor || BORDER_COLOR_DEFAULT, onChange: (newColor) => {
                        return updateDataframeFormatParams({ border: { borderColor: newColor } });
                    } })))));
};
export default SetDataframeFormatTaskpane;
//# sourceMappingURL=SetDataframeFormatTaskpane.js.map