// Copyright (c) Mito
import React from 'react';
import "../../../../css/taskpanes/DefaultTaskpane.css";
import { classNames } from '../../../utils/classNames';
import MitoProUpgradePrompt from '../../elements/MitoProUpgradePrompt';
/*
    A container for the main content of a taskpane. Usually wrapped in
    a DefaultTaskpane.
*/
const DefaultTaskpaneBody = (props) => {
    var _a;
    const promptUpgrade = !((_a = props.userProfile) === null || _a === void 0 ? void 0 : _a.isPro) && props.requiresPro;
    return (React.createElement(React.Fragment, null,
        promptUpgrade &&
            React.createElement(MitoProUpgradePrompt, { message: props.requiresProMessage }),
        React.createElement("div", { className: classNames('default-taskpane-body-div', { 'default-taskpane-body-div-no-scroll': props.noScroll, 'default-taskpane-body-disabled': promptUpgrade }) }, props.children)));
};
export default DefaultTaskpaneBody;
//# sourceMappingURL=DefaultTaskpaneBody.js.map