// Copyright (c) Mito
import React, { useEffect, useState } from 'react';
import "../../../../../css/taskpanes/ControlPanel/ColumnSummaryStatistics.css";
import { formatCellData } from '../../../../utils/format';
import OpenFillNaN from '../../FillNa/OpenFillNaN';
const KEY_TO_FORMAT_WITH_COLUMN_FORMAT = [
    'mean',
    'std',
    'min',
    '25%',
    '50%',
    '75%',
    'max',
    'median',
    'sum'
];
/*
    Displays the column summary statistics gotten from
    a call to .describe

    See examples here: https://pandas.pydata.org/pandas-docs/stable/reference/api/pandas.Series.describe.html
*/
function ColumnSummaryStatistics(props) {
    const [describe, setDescribe] = useState({});
    const [loading, setLoading] = useState(true);
    async function loadDescribe() {
        const loadedDescribe = await props.mitoAPI.getColumnDescribe(props.selectedSheetIndex, props.columnID);
        setDescribe(loadedDescribe);
        setLoading(false);
    }
    useEffect(() => {
        void loadDescribe();
    }, []);
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: 'text-header-3' },
            React.createElement("p", null, " Column Summary Statistics ")),
        React.createElement("div", { key: loading.toString() },
            !loading &&
                React.createElement("table", { className: 'column-describe-table-container' }, Object.keys(describe).map(key => {
                    const value = describe[key];
                    let valueToDisplay = value;
                    // Add the format, if there is one for this column
                    if (KEY_TO_FORMAT_WITH_COLUMN_FORMAT.includes(key)) {
                        valueToDisplay = formatCellData(value, props.columnDtype, props.columnFormat);
                    }
                    // We clip data at 15 letters for now. We also format
                    valueToDisplay = valueToDisplay.substring(0, 15) + (valueToDisplay.length > 15 ? '...' : '');
                    return (React.createElement("tr", { className: 'column-describe-table-row', key: key },
                        React.createElement("th", null,
                            key,
                            key === 'count: NaN' && valueToDisplay !== "0" &&
                                React.createElement(OpenFillNaN, { setUIState: props.setUIState, columnID: props.columnID })),
                        React.createElement("th", null, valueToDisplay)));
                })),
            loading &&
                React.createElement("p", null, "Column Summary statistics are loading..."))));
}
export default ColumnSummaryStatistics;
//# sourceMappingURL=ColumnSummaryStatistics.js.map