import React from 'react';
import '../../../css/endo/GridData.css';
import { getBorderStyle, getIsCellSelected } from './selectionUtils';
import { calculateCurrentSheetView } from './sheetViewUtils';
import { classNames } from '../../utils/classNames';
import { getColumnIDsArrayFromSheetDataArray } from './utils';
import { formatCellData } from '../../utils/format';
import { isNumberDtype } from '../../utils/dtypes';
export const EVEN_ROW_BACKGROUND_COLOR_DEFAULT = '#F5F5F5';
export const ODD_ROW_BACKGROUND_COLOR_DEFAULT = '#FFFFFF';
export const EVEN_ROW_TEXT_COLOR_DEFAULT = '#494650'; // This is var(--mito-gray), update if we change variable
export const ODD_ROW_TEXT_COLOR_DEFAULT = '#494650'; // This is var(--mito-gray), update if we change variable
const GridData = (props) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
    const currentSheetView = calculateCurrentSheetView(props.gridState);
    const sheetData = props.sheetData;
    const evenRowBackgroundColor = ((_c = (_b = (_a = sheetData === null || sheetData === void 0 ? void 0 : sheetData.dfFormat) === null || _a === void 0 ? void 0 : _a.rows) === null || _b === void 0 ? void 0 : _b.even) === null || _c === void 0 ? void 0 : _c.backgroundColor) || EVEN_ROW_BACKGROUND_COLOR_DEFAULT;
    const oddRowBackgroundColor = ((_f = (_e = (_d = sheetData === null || sheetData === void 0 ? void 0 : sheetData.dfFormat) === null || _d === void 0 ? void 0 : _d.rows) === null || _e === void 0 ? void 0 : _e.odd) === null || _f === void 0 ? void 0 : _f.backgroundColor) || ODD_ROW_BACKGROUND_COLOR_DEFAULT;
    const evenRowTextColor = ((_j = (_h = (_g = sheetData === null || sheetData === void 0 ? void 0 : sheetData.dfFormat) === null || _g === void 0 ? void 0 : _g.rows) === null || _h === void 0 ? void 0 : _h.even) === null || _j === void 0 ? void 0 : _j.color) || EVEN_ROW_TEXT_COLOR_DEFAULT;
    const oddRowTextColor = ((_m = (_l = (_k = sheetData === null || sheetData === void 0 ? void 0 : sheetData.dfFormat) === null || _k === void 0 ? void 0 : _k.rows) === null || _l === void 0 ? void 0 : _l.odd) === null || _m === void 0 ? void 0 : _m.color) || ODD_ROW_TEXT_COLOR_DEFAULT;
    return (React.createElement(React.Fragment, null, sheetData && sheetData.numRows > 0 && Array(currentSheetView.numRowsRendered).fill(0).map((_, _rowIndex) => {
        const rowIndex = currentSheetView.startingRowIndex + _rowIndex;
        const columnIDs = getColumnIDsArrayFromSheetDataArray([sheetData])[0];
        const rowClassNames = classNames('mito-grid-row', {
            'mito-grid-row-even': rowIndex % 2 === 0,
            'mito-grid-row-odd': rowIndex % 2 !== 0
        });
        const style = rowIndex % 2 === 0
            ? { backgroundColor: evenRowBackgroundColor, color: evenRowTextColor }
            : { backgroundColor: oddRowBackgroundColor, color: oddRowTextColor };
        return (React.createElement("div", { className: rowClassNames, key: rowIndex, style: style }, Array(currentSheetView.numColumnsRendered).fill(0).map((_, _colIndex) => {
            var _a, _b, _c, _d;
            const columnIndex = currentSheetView.startingColumnIndex + _colIndex;
            const columnID = columnIDs[columnIndex];
            const columnDtype = (_b = (_a = props.sheetData) === null || _a === void 0 ? void 0 : _a.data[columnIndex]) === null || _b === void 0 ? void 0 : _b.columnDtype;
            const columnFormatType = sheetData.dfFormat.columns[columnID];
            const cellData = (_d = (_c = props.sheetData) === null || _c === void 0 ? void 0 : _c.data[columnIndex]) === null || _d === void 0 ? void 0 : _d.columnData[rowIndex];
            if (cellData === undefined || columnDtype == undefined) {
                return null;
            }
            const className = classNames('mito-grid-cell', 'text-unselectable', {
                'mito-grid-cell-selected': getIsCellSelected(props.gridState.selections, rowIndex, columnIndex),
                'mito-grid-cell-hidden': props.editorState !== undefined && props.editorState.rowIndex === rowIndex && props.editorState.columnIndex === columnIndex,
                'right-align-number-series': isNumberDtype(columnDtype)
            });
            const cellWidth = props.gridState.widthDataArray[props.gridState.sheetIndex].widthArray[columnIndex];
            // Format the cell
            const displayCellData = formatCellData(cellData, columnDtype, columnFormatType);
            return (React.createElement("div", { className: className, key: columnIndex, style: Object.assign({ width: `${cellWidth}px` }, getBorderStyle(props.gridState.selections, props.gridState.copiedSelections, rowIndex, columnIndex, sheetData.numRows)), tabIndex: -1, "mito-col-index": columnIndex, "mito-row-index": rowIndex, title: displayCellData }, displayCellData));
        })));
    })));
};
export default React.memo(GridData);
//# sourceMappingURL=GridData.js.map