// Copyright (c) Mito
import React from 'react';
import '../../../css/elements/MultiToggleBox.css';
import { classNames } from '../../utils/classNames';
import Col from '../layout/Col';
import Row from '../layout/Row';
/*
  A single item that can be toggled
*/
const MultiToggleItem = (props) => {
    var _a;
    return (React.createElement("div", { className: classNames('multi-toggle-box-row', 'text-overflow-hide', {
            'multi-toggle-box-row-selected': props.toggled,
            'multi-toggle-box-row-disabled': props.disabled
        }), onClick: () => {
            if (props.disabled) {
                return;
            }
            props.onToggle();
        } },
        React.createElement(Row
        // Space differently depending if we have right text or not
        , { 
            // Space differently depending if we have right text or not
            justify: props.rightText !== undefined ? 'space-between' : 'start', align: 'center', suppressTopBottomMargin: true },
            React.createElement(Col, { offset: 1 },
                React.createElement("input", { name: 'input', type: "checkbox", checked: props.toggled })),
            React.createElement(Col, { span: 14 },
                React.createElement("span", { title: (_a = props.title) === null || _a === void 0 ? void 0 : _a.toString() }, props.title)),
            props.rightText &&
                React.createElement(Col, { span: 7, offset: 1 }, props.rightText))));
};
export default MultiToggleItem;
//# sourceMappingURL=MultiToggleItem.js.map