import React from "react";
import { isExperimentActive, isVariantA } from "../../utils/experiments";
/**
 * This component is used to render a different component depending
 * what experiment is active.
 */
const Experiment = (props) => {
    // If we are not running this experiment, then we simply default to the aElement
    if (!isExperimentActive(props.analysisData, props.experimentID)) {
        return React.createElement(React.Fragment, null, props.aElement);
    }
    else {
        if (isVariantA(props.analysisData)) {
            return React.createElement(React.Fragment, null, props.aElement);
        }
        else {
            return React.createElement(React.Fragment, null, props.bElement);
        }
    }
};
export default Experiment;
//# sourceMappingURL=Experiment.js.map