// Copyright (c) Mito
import React, { useState } from 'react';
import Col from '../layout/Col';
import Row from '../layout/Row';
import DropdownItem from './DropdownItem';
import Select from './Select';
/**
 * The DataframeSelect component is a commonly used component in taskpanes
 * that allows users to select which dataframe they want to operate on. It
 * comes with a label.
 */
const DataframeSelect = (props) => {
    // We only show the names that were initially used when this element is
    // rendered, as the dataframe selects never want to let users select
    // new sheets that have been created
    const [dfNames] = useState(() => props.sheetDataArray
        .map(sheetData => sheetData.dfName)
        .filter((dfName, sheetIndex) => { return sheetIndex !== props.sheetIndexToIgnore; }));
    return (React.createElement(Row, { justify: 'space-between', align: 'center', title: props.title },
        React.createElement(Col, null,
            React.createElement("p", { className: 'text-header-3' }, "Dataframe")),
        React.createElement(Col, null,
            React.createElement(Select, { width: 'medium', value: dfNames[props.sheetIndex], onChange: (newDfName) => {
                    const newSheetIndex = dfNames.findIndex((dfName) => dfName === newDfName);
                    // Only callback on real changes
                    if (newSheetIndex !== -1 && newSheetIndex !== props.sheetIndex) {
                        props.onChange(newSheetIndex);
                    }
                } }, dfNames.map(dfName => {
                return (React.createElement(DropdownItem, { key: dfName, title: dfName }));
            })))));
};
export default DataframeSelect;
//# sourceMappingURL=DataframeSelect.js.map