import java.io
import java.util
import opennlp.tools.chunker
import opennlp.tools.ml.model
import opennlp.tools.util
import opennlp.tools.util.eval
import opennlp.tools.util.model
import org.cogroo.dictionary
import org.cogroo.tools.chunker2
import typing



class DefaultFeaturizerSequenceValidator(opennlp.tools.util.SequenceValidator[org.cogroo.tools.chunker2.TokenTag]):
    def __init__(self, featureDictionary: org.cogroo.dictionary.FeatureDictionary, set: java.util.Set[str]): ...
    @staticmethod
    def matches(string: str, string2: str) -> bool: ...
    def validSequence(self, int: int, tokenTagArray: typing.List[org.cogroo.tools.chunker2.TokenTag], stringArray: typing.List[str], string2: str) -> bool: ...

class FeatureSample:
    @typing.overload
    def __init__(self, stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str], stringArray4: typing.List[str]): ...
    @typing.overload
    def __init__(self, list: java.util.List[str], list2: java.util.List[str], list3: java.util.List[str], list4: java.util.List[str]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getFeatures(self) -> typing.List[str]: ...
    def getLemmas(self) -> typing.List[str]: ...
    def getSentence(self) -> typing.List[str]: ...
    def getTags(self) -> typing.List[str]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class FeatureSampleStream(opennlp.tools.util.FilterObjectStream[str, FeatureSample]):
    def __init__(self, objectStream: opennlp.tools.util.ObjectStream[str]): ...
    def read(self) -> FeatureSample: ...

class Featurizer:
    def featurize(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[str]: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[opennlp.tools.util.Sequence]: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str], double: float) -> typing.List[opennlp.tools.util.Sequence]: ...

class FeaturizerContextGenerator(opennlp.tools.util.BeamSearchContextGenerator[org.cogroo.tools.chunker2.TokenTag]):
    @typing.overload
    def getContext(self, int: int, tArray: typing.List[typing.Any], stringArray: typing.List[str], objectArray: typing.List[typing.Any]) -> typing.List[str]: ...
    @typing.overload
    def getContext(self, int: int, stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> typing.List[str]: ...

class FeaturizerCrossValidator:
    def __init__(self, string: str, trainingParameters: opennlp.tools.util.TrainingParameters, featureDictionary: org.cogroo.dictionary.FeatureDictionary, string2: str, string3: str, featurizerEvaluationMonitorArray: typing.List['FeaturizerEvaluationMonitor']): ...
    def evaluate(self, objectStream: opennlp.tools.util.ObjectStream[FeatureSample], int: int) -> None: ...
    def getWordAccuracy(self) -> float: ...
    def getWordCount(self) -> int: ...

class FeaturizerEvaluationMonitor(opennlp.tools.util.eval.EvaluationMonitor[FeatureSample]): ...

class FeaturizerEvaluator(opennlp.tools.util.eval.Evaluator[FeatureSample]):
    def __init__(self, featurizer: Featurizer, featurizerEvaluationMonitorArray: typing.List[FeaturizerEvaluationMonitor]): ...
    def getWordAccuracy(self) -> float: ...
    def getWordCount(self) -> int: ...

class FeaturizerEventStream(opennlp.tools.util.AbstractEventStream[FeatureSample]):
    def __init__(self, objectStream: opennlp.tools.util.ObjectStream[FeatureSample], featurizerContextGenerator: FeaturizerContextGenerator): ...

class FeaturizerFactory(opennlp.tools.util.BaseToolFactory):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, featureDictionary: org.cogroo.dictionary.FeatureDictionary, string: str): ...
    @typing.overload
    @staticmethod
    def create(class_: typing.Type[opennlp.tools.util.BaseToolFactory], artifactProvider: opennlp.tools.util.model.ArtifactProvider) -> opennlp.tools.util.BaseToolFactory: ...
    @typing.overload
    @staticmethod
    def create(string: str, artifactProvider: opennlp.tools.util.model.ArtifactProvider) -> opennlp.tools.util.BaseToolFactory: ...
    @typing.overload
    @staticmethod
    def create(string: str, featureDictionary: org.cogroo.dictionary.FeatureDictionary, string2: str) -> 'FeaturizerFactory': ...
    def createArtifactMap(self) -> java.util.Map[str, typing.Any]: ...
    def createArtifactSerializersMap(self) -> java.util.Map[str, opennlp.tools.util.model.ArtifactSerializer]: ...
    def createManifestEntries(self) -> java.util.Map[str, str]: ...
    def getCGFlags(self) -> str: ...
    def getDictionaryPoisonedTags(self) -> java.util.Set[str]: ...
    def getFeatureDictionary(self) -> org.cogroo.dictionary.FeatureDictionary: ...
    def getFeaturizerContextGenerator(self) -> FeaturizerContextGenerator: ...
    def getSequenceValidator(self) -> opennlp.tools.util.SequenceValidator[org.cogroo.tools.chunker2.TokenTag]: ...
    def validateArtifactMap(self) -> None: ...

class FeaturizerModel(opennlp.tools.util.model.BaseModel):
    FEATURIZER_MODEL_ENTRY_NAME: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, string: str, maxentModel: opennlp.tools.ml.model.MaxentModel, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], featurizerFactory: FeaturizerFactory): ...
    def getChunkerSequenceModel(self) -> opennlp.tools.ml.model.SequenceClassificationModel[org.cogroo.tools.chunker2.TokenTag]: ...
    def getFactory(self) -> FeaturizerFactory: ...
    def getFeatureDictionary(self) -> org.cogroo.dictionary.FeatureDictionary: ...
    def getFeaturizerModel(self) -> opennlp.tools.ml.model.AbstractModel: ...

class WordTag:
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @typing.overload
    @staticmethod
    def create(stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List['WordTag']: ...
    @typing.overload
    @staticmethod
    def create(stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> typing.List['WordTag']: ...
    @typing.overload
    @staticmethod
    def create(chunkSample: opennlp.tools.chunker.ChunkSample) -> typing.List['WordTag']: ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def extract(wordTagArray: typing.List['WordTag'], stringArray: typing.List[str], stringArray2: typing.List[str]) -> None: ...
    @typing.overload
    @staticmethod
    def extract(wordTagArray: typing.List['WordTag'], stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> None: ...
    def getChunktag(self) -> str: ...
    def getPostag(self) -> str: ...
    def getWord(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class DefaultFeaturizerContextGenerator(FeaturizerContextGenerator):
    def __init__(self, string: str): ...
    @typing.overload
    def getContext(self, int: int, stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> typing.List[str]: ...
    @typing.overload
    def getContext(self, int: int, tokenTagArray: typing.List[org.cogroo.tools.chunker2.TokenTag], stringArray: typing.List[str], objectArray: typing.List[typing.Any]) -> typing.List[str]: ...

class DefaultFeaturizerFactory(FeaturizerFactory):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, featureDictionary: org.cogroo.dictionary.FeatureDictionary, string: str): ...
    def createArtifactMap(self) -> java.util.Map[str, typing.Any]: ...
    def createArtifactSerializersMap(self) -> java.util.Map[str, opennlp.tools.util.model.ArtifactSerializer]: ...
    def validateArtifactMap(self) -> None: ...

class FSAFeaturizerFactory(FeaturizerFactory):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, featureDictionary: org.cogroo.dictionary.FeatureDictionary, string: str): ...
    def createArtifactMap(self) -> java.util.Map[str, typing.Any]: ...
    def createArtifactSerializersMap(self) -> java.util.Map[str, opennlp.tools.util.model.ArtifactSerializer]: ...

class FeaturizerME(Featurizer):
    DEFAULT_BEAM_SIZE: typing.ClassVar[int] = ...
    def __init__(self, featurizerModel: FeaturizerModel): ...
    def featurize(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[str]: ...
    @typing.overload
    def probs(self) -> typing.List[float]: ...
    @typing.overload
    def probs(self, doubleArray: typing.List[float]) -> None: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[opennlp.tools.util.Sequence]: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str], double: float) -> typing.List[opennlp.tools.util.Sequence]: ...
    @staticmethod
    def train(string: str, objectStream: opennlp.tools.util.ObjectStream[FeatureSample], trainingParameters: opennlp.tools.util.TrainingParameters, featurizerFactory: FeaturizerFactory) -> FeaturizerModel: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.cogroo.tools.featurizer")``.

    DefaultFeaturizerContextGenerator: typing.Type[DefaultFeaturizerContextGenerator]
    DefaultFeaturizerFactory: typing.Type[DefaultFeaturizerFactory]
    DefaultFeaturizerSequenceValidator: typing.Type[DefaultFeaturizerSequenceValidator]
    FSAFeaturizerFactory: typing.Type[FSAFeaturizerFactory]
    FeatureSample: typing.Type[FeatureSample]
    FeatureSampleStream: typing.Type[FeatureSampleStream]
    Featurizer: typing.Type[Featurizer]
    FeaturizerContextGenerator: typing.Type[FeaturizerContextGenerator]
    FeaturizerCrossValidator: typing.Type[FeaturizerCrossValidator]
    FeaturizerEvaluationMonitor: typing.Type[FeaturizerEvaluationMonitor]
    FeaturizerEvaluator: typing.Type[FeaturizerEvaluator]
    FeaturizerEventStream: typing.Type[FeaturizerEventStream]
    FeaturizerFactory: typing.Type[FeaturizerFactory]
    FeaturizerME: typing.Type[FeaturizerME]
    FeaturizerModel: typing.Type[FeaturizerModel]
    WordTag: typing.Type[WordTag]
