/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.checkers;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cogroo.entities.Mistake;
import org.cogroo.entities.Sentence;
import org.cogroo.tools.checker.AbstractTypedChecker;
import org.cogroo.tools.checker.JavaRuleDefinition;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;

public class PunctuationChecker
extends AbstractTypedChecker {
    private static final String ID_PREFIX = "punctuation:";
    private static final String[] SUGGESTION_NO_PUNCTUATION = new String[]{""};
    private static final String CATEGORY = "Erros mec\u00e2nicos";
    private static final String GROUP = "Pontua\u00e7\u00e3o";
    static final String BEFORE_SENTENCES_ID = "punctuation:BEFORE_SENTENCES";
    private static final Pattern BEFORE_SENTENCES = Pattern.compile("^([])},.;:?!]+)");
    static final String EXTRA_PUNCTUATION_ID = "punctuation:EXTRA_PUNCTUATION";
    private static final Pattern EXTRA_PUNCTUATION = Pattern.compile("([,.;:?!]{2,})");
    private static final Pattern EXCEPTION = Pattern.compile("^(([.]{3})|((!\\?)|(\\?!)))$");

    public PunctuationChecker() {
        this.add(this.createRuleDefinition(BEFORE_SENTENCES_ID, BEFORE_SENTENCES, "Pontua\u00e7\u00e3o no in\u00edcio da frase. A frase n\u00e3o deve come\u00e7ar com um sinal de pontua\u00e7\u00e3o.", "Pontua\u00e7\u00e3o no in\u00edcio da frase.", PunctuationChecker.createExample("!Este programa \u00e9 bom.", "Este programa \u00e9 bom."))).add(this.createRuleDefinition(EXTRA_PUNCTUATION_ID, EXTRA_PUNCTUATION, "Excesso de sinais de pontua\u00e7\u00e3o. A repeti\u00e7\u00e3o dos sinais de pontua\u00e7\u00e3o deve ser evitada.", "Excesso de sinais de pontua\u00e7\u00e3o.", PunctuationChecker.createExample("Este programa \u00e9 bom!!", "Este programa \u00e9 bom!")));
    }

    private RuleDefinition createRuleDefinition(String id, Pattern regex, String message, String shortMessage, Example example) {
        String description = "Aplica a express\u00e3o regular " + regex.pattern() + " na senten\u00e7a.";
        LinkedList<Example> examples = new LinkedList<Example>();
        examples.add(example);
        return new JavaRuleDefinition(id, CATEGORY, GROUP, description, message, shortMessage, examples);
    }

    @Override
    public String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public List<Mistake> check(Sentence sentence) {
        Matcher m;
        String text = sentence.getSentence();
        LinkedList<Mistake> mistakes = new LinkedList<Mistake>();
        int offset = sentence.getSpan().getStart();
        if (this.isCheckRule(BEFORE_SENTENCES_ID)) {
            m = BEFORE_SENTENCES.matcher(text);
            while (m.find()) {
                int start = m.start(1) + offset;
                int end = m.end(1) + offset;
                mistakes.add(this.createMistake(BEFORE_SENTENCES_ID, SUGGESTION_NO_PUNCTUATION, start, end, sentence.getSentence()));
            }
        }
        if (this.isCheckRule(EXTRA_PUNCTUATION_ID)) {
            m = EXTRA_PUNCTUATION.matcher(text);
            while (m.find()) {
                String error = m.group(1);
                if (EXCEPTION.matcher(error).matches()) continue;
                int start = m.start(1) + offset;
                int end = m.end(1) + offset;
                String[] suggestion = new String[]{this.createSuggestion(m.group(1))};
                mistakes.add(this.createMistake(EXTRA_PUNCTUATION_ID, suggestion, start, end, sentence.getSentence()));
            }
        }
        return mistakes;
    }

    private String createSuggestion(String error) {
        char first = error.charAt(0);
        String suggestion = Character.toString(first);
        switch (first) {
            case '.': {
                if (error.charAt(1) != '.') break;
                suggestion = "...";
                break;
            }
            case '!': {
                if (error.charAt(1) != '?') break;
                suggestion = "!?";
                break;
            }
            case '?': {
                if (error.charAt(1) != '!') break;
                suggestion = "?!";
                break;
            }
        }
        return suggestion;
    }

    @Override
    public int getPriority() {
        return 2000;
    }
}

