/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.featurizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.postag.ExtendedPOSDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ModelUtil;
import org.cogroo.cmdline.featurizer.TrainingParams;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.FeaturizerFactory;
import org.cogroo.tools.featurizer.FeaturizerME;
import org.cogroo.tools.featurizer.FeaturizerModel;

public class FeaturizerTrainerTool
extends AbstractTrainerTool<FeatureSample, TrainerToolParams> {
    public FeaturizerTrainerTool() {
        super(FeatureSample.class, TrainerToolParams.class);
    }

    @Override
    public String getName() {
        return "FeaturizerTrainerME";
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable Featurizer";
    }

    @Override
    public void run(String format, String[] args) {
        FeaturizerModel model;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("featurizer model", modelOutFile);
        try {
            ExtendedPOSDictionary tagdict = null;
            if (((TrainerToolParams)this.params).getDict() != null) {
                tagdict = ExtendedPOSDictionary.create(new FileInputStream(((TrainerToolParams)this.params).getDict()));
            }
            FeaturizerFactory featurizerFactory = null;
            try {
                featurizerFactory = FeaturizerFactory.create(((TrainerToolParams)this.params).getFactory(), tagdict, ((TrainerToolParams)this.params).getCGFlags());
            }
            catch (InvalidFormatException e) {
                throw new TerminateToolException(-1, e.getMessage());
            }
            model = FeaturizerME.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, this.mlParams, featurizerFactory);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage());
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("Featurizer", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

