/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import org.apache.log4j.config.PropertiesConfiguration;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="Log4j1PropertiesConfigurationFactory", category="ConfigurationFactory")
@Order(value=2)
public class PropertiesConfigurationFactory
extends ConfigurationFactory {
    protected static final String TEST_PREFIX = "log4j-test";
    protected static final String DEFAULT_PREFIX = "log4j";

    @Override
    protected String[] getSupportedTypes() {
        if (!PropertiesUtil.getProperties().getBooleanProperty("log4j1.compatibility", Boolean.FALSE)) {
            return null;
        }
        return new String[]{".properties"};
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        int interval = PropertiesUtil.getProperties().getIntegerProperty("log4j1.monitorInterval", 0);
        return new PropertiesConfiguration(loggerContext, source, interval);
    }

    @Override
    protected String getTestPrefix() {
        return TEST_PREFIX;
    }

    @Override
    protected String getDefaultPrefix() {
        return DEFAULT_PREFIX;
    }

    @Override
    protected String getVersion() {
        return "1";
    }
}

