/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.interpreters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.tools.util.Cache;
import org.apache.log4j.Logger;
import org.cogroo.entities.impl.ChunkTag;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.interpreters.TagInterpreter;
import org.cogroo.tools.checker.rules.model.TagMask;

public class JspellTagInterpreter
implements TagInterpreter {
    private static final Map<Enum<?>, String> ENUM_MTAG_PARTS;
    private static final Map<String, List<Enum<?>>> MTAG_PARTS_ENUM;
    protected static final Logger LOGGER;
    private static final String SEP = "\\|";
    private static final List<String> MOOD_INDICATIVE;
    private final Cache cache = new Cache(200);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MorphologicalTag parseMorphologicalTag(String tagString) {
        String[] tags;
        if (tagString == null) {
            return null;
        }
        Cache cache = this.cache;
        synchronized (cache) {
            if (this.cache.containsKey(tagString)) {
                return ((MorphologicalTag)this.cache.get(tagString)).clone();
            }
        }
        MorphologicalTag m = new MorphologicalTag();
        for (String tag : tags = tagString.split(SEP)) {
            if (MTAG_PARTS_ENUM.containsKey(tag)) {
                List<Enum<?>> tagE = MTAG_PARTS_ENUM.get(tag);
                for (Enum<?> t : tagE) {
                    if (t instanceof TagMask.Class) {
                        m.setClazz((TagMask.Class)t);
                        continue;
                    }
                    if (t instanceof TagMask.Gender) {
                        m.setGender((TagMask.Gender)t);
                        continue;
                    }
                    if (t instanceof TagMask.Number) {
                        m.setNumber((TagMask.Number)t);
                        continue;
                    }
                    if (t instanceof TagMask.Case) {
                        m.setCase((TagMask.Case)t);
                        continue;
                    }
                    if (t instanceof TagMask.Person) {
                        m.setPerson((TagMask.Person)t);
                        continue;
                    }
                    if (t instanceof TagMask.Tense) {
                        if (MOOD_INDICATIVE.contains(tag)) {
                            m.setMood(TagMask.Mood.INDICATIVE);
                        }
                        m.setTense((TagMask.Tense)t);
                        continue;
                    }
                    if (t instanceof TagMask.Mood) {
                        m.setMood((TagMask.Mood)t);
                        continue;
                    }
                    if (!(t instanceof TagMask.Punctuation)) continue;
                    m.setPunctuation((TagMask.Punctuation)t);
                }
                continue;
            }
            if (tag.startsWith("CAT:")) {
                if (tag.startsWith("CAT:punct")) {
                    m.setClazz(TagMask.Class.PUNCTUATION_MARK);
                    continue;
                }
                if ("CAT:v".equals(tag) && m.getClazzE() == null) {
                    m.setClazz(TagMask.Class.FINITIVE_VERB);
                    continue;
                }
                if ("CAT:ppos".equals(tag) || "CAT:pind".equals(tag) || "CAT:pdem".equals(tag) || "CAT:pint".equals(tag) || "CAT:prel".equals(tag)) {
                    m.setClazz(TagMask.Class.PRONOUN);
                    continue;
                }
                if ("CAT:card".equals(tag) || "CAT:nord".equals(tag)) {
                    m.setClazz(TagMask.Class.NUMERAL);
                    continue;
                }
                if (tag.startsWith("CAT:adj")) {
                    m.setClazz(TagMask.Class.ADJECTIVE);
                    continue;
                }
                if (!"CAT:cp".equals(tag) && !"CAT:pass".equals(tag)) continue;
                return null;
            }
            if (tag.startsWith("T:")) {
                if (MOOD_INDICATIVE.contains(tag)) {
                    m.setMood(TagMask.Mood.INDICATIVE);
                }
                if (!TagMask.Class.FINITIVE_VERB.equals((Object)m.getClazzE()) && m.getClazzE() != null) continue;
                if ("T:inf".equals(tag) || "T:ip".equals(tag)) {
                    m.setClazz(TagMask.Class.INFINITIVE_VERB);
                    continue;
                }
                if ("T:ppa".equals(tag)) {
                    m.setClazz(TagMask.Class.PARTICIPLE_VERB);
                    continue;
                }
                if (!"T:g".equals(tag)) continue;
                m.setClazz(TagMask.Class.GERUND_VERB);
                continue;
            }
            if (tag.length() == 1 || "--".equals(tag) || "...".equals(tag)) {
                m.setClazz(TagMask.Class.PUNCTUATION_MARK);
                continue;
            }
            if ("n:".equals(tag)) {
                m.setClazz(TagMask.Class.NOUN);
                continue;
            }
            if ("intj".equals(tag)) {
                m.setClazz(TagMask.Class.INTERJECTION);
                continue;
            }
            if ("pp".equals(tag)) {
                m.setClazz(TagMask.Class.PREPOSITION);
                continue;
            }
            if ("np".equals(tag)) {
                m.setClazz(TagMask.Class.NOUN);
                continue;
            }
            System.out.println(tag);
        }
        if (m.toString() == null || m.toString().length() == 0) {
            LOGGER.error("Invalid MorphologicalTag: " + tagString);
        }
        if (m.getGenderE() == null && m.getNumberE() != null) {
            if (TagMask.Class.NOUN.equals((Object)m.getClazzE()) || TagMask.Class.NOUN_ADJECTIVE.equals((Object)m.getClazzE()) || TagMask.Class.NUMERAL.equals((Object)m.getClazzE())) {
                m.setGender(TagMask.Gender.NEUTRAL);
            } else if (TagMask.Class.PROPER_NOUN.equals((Object)m.getClazzE())) {
                m.setGender(TagMask.Gender.MALE);
            }
        }
        if (m.getNumberE() == null && m.getGenderE() != null) {
            if (TagMask.Class.NOUN.equals((Object)m.getClazzE()) || TagMask.Class.NOUN_ADJECTIVE.equals((Object)m.getClazzE()) || TagMask.Class.NUMERAL.equals((Object)m.getClazzE())) {
                m.setNumber(TagMask.Number.NEUTRAL);
            } else if (TagMask.Class.PROPER_NOUN.equals((Object)m.getClazzE())) {
                m.setNumber(TagMask.Number.SINGULAR);
            }
        }
        if (m.getTense() != null && TagMask.Class.NOUN.equals((Object)m.getClazzE())) {
            m.setClazz(TagMask.Class.INFINITIVE_VERB);
        }
        if (m == null || m.getClazzE() == null) {
            LOGGER.warn("something wrong with tag: " + tagString);
        }
        this.removeInvalidFeatures(m);
        Cache cache2 = this.cache;
        synchronized (cache2) {
            if (!this.cache.containsKey(tagString)) {
                this.cache.put(tagString, m.clone());
            }
        }
        return m;
    }

    private void removeInvalidFeatures(MorphologicalTag m) {
        if (m != null && m.getClazzE() != null) {
            switch (m.getClazzE()) {
                case ADVERB: {
                    m.setCase(null);
                    m.setGender(null);
                    m.setMood(null);
                    m.setNumber(null);
                    m.setPerson(null);
                    m.setPunctuation(null);
                    m.setTense(null);
                    break;
                }
                case NOUN: 
                case PRONOUN: {
                    m.setPerson(null);
                    m.setMood(null);
                    m.setCase(null);
                    break;
                }
                case FINITIVE_VERB: {
                    m.setGender(null);
                    break;
                }
                case INFINITIVE_VERB: {
                    m.setCase(null);
                    m.setGender(null);
                    m.setMood(null);
                    m.setPunctuation(null);
                    m.setTense(null);
                }
            }
        }
    }

    @Override
    public ChunkTag parseChunkTag(String tagString) {
        return null;
    }

    @Override
    public SyntacticTag parseSyntacticTag(String tagString) {
        return null;
    }

    @Override
    public String serialize(MorphologicalTag tag) {
        StringBuilder res = new StringBuilder();
        if (tag.getClazzE() != null) {
            res.append(this.serializer(tag.getClazzE()) + SEP);
        }
        if (tag.getGenderE() != null) {
            res.append(this.serializer(tag.getGenderE()) + SEP);
        }
        if (tag.getTense() != null) {
            res.append(this.serializer(tag.getTense()) + SEP);
        }
        if (tag.getMood() != null && tag.getTense() == null) {
            res.append(this.serializer(tag.getMood()) + SEP);
        }
        if (tag.getPersonE() != null && tag.getNumberE() != null) {
            String s = this.serializer(tag.getPersonE());
            if (!s.contains("S") && !s.contains("P")) {
                res.append(s + this.serializer(tag.getNumberE()) + SEP);
            } else {
                res.append(s + SEP);
            }
        } else if (tag.getNumberE() != null) {
            res.append(this.serializer(tag.getNumberE()) + SEP);
        }
        if (tag.getCase() != null) {
            res.append(this.serializer(tag.getCase()) + SEP);
        }
        if (tag.getMood() != null && tag.getTense() != null) {
            res.append(this.serializer(tag.getMood()) + SEP);
        }
        if (tag.getPunctuation() != null) {
            res.append(this.serializer(tag.getPunctuation()) + SEP);
        }
        if (res.length() == 0) {
            LOGGER.error("Unable to serialize MorphologicalTag: " + tag);
        }
        if (res.length() > 1) {
            return res.substring(0, res.length() - 1);
        }
        return null;
    }

    @Override
    public String serialize(ChunkTag tag) {
        String value = this.serializer(tag.getChunkFunction());
        return value;
    }

    @Override
    public String serialize(SyntacticTag tag) {
        String value = this.serializer(tag.getSyntacticFunction());
        return value;
    }

    @Override
    public String serialize(TagMask.SyntacticFunction tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.ChunkFunction tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Class tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Gender tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Number tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Case tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Person tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Tense tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Mood tag) {
        return this.serializer(tag);
    }

    @Override
    public String serialize(TagMask.Punctuation tag) {
        return this.serializer(tag);
    }

    private String serializer(Enum<?> value) {
        if (ENUM_MTAG_PARTS.containsKey(value)) {
            return ENUM_MTAG_PARTS.get(value);
        }
        return "";
    }

    static {
        LOGGER = Logger.getLogger(JspellTagInterpreter.class);
        HashMap<Enum, String> menumElements = new HashMap<Enum, String>();
        menumElements.put(TagMask.Class.NOUN, "CAT:nc");
        menumElements.put(TagMask.Class.NOUN_ADJECTIVE, "CAT:a_nc");
        menumElements.put(TagMask.Class.PROPER_NOUN, "CAT:np");
        menumElements.put(TagMask.Class.ARTICLE, "CAT:art");
        menumElements.put(TagMask.Class.PREPOSITION, "CAT:prep");
        menumElements.put(TagMask.Class.ADJECTIVE, "CAT:adj");
        menumElements.put(TagMask.Class.ADVERB, "CAT:adv");
        menumElements.put(TagMask.Class.SUBORDINATING_CONJUNCTION, "CAT:conj-s");
        menumElements.put(TagMask.Class.COORDINATING_CONJUNCTION, "CAT:conj-c");
        menumElements.put(TagMask.Class.INTERJECTION, "CAT:in");
        menumElements.put(TagMask.Class.PREFIX, "CAT:pref");
        menumElements.put(TagMask.Class.PERSONAL_PRONOUN, "CAT:ppes");
        menumElements.put(TagMask.Gender.MALE, "G:m");
        menumElements.put(TagMask.Gender.FEMALE, "G:f");
        menumElements.put(TagMask.Gender.NEUTRAL, "G:n");
        menumElements.put(TagMask.Number.SINGULAR, "N:s");
        menumElements.put(TagMask.Number.PLURAL, "N:p");
        menumElements.put(TagMask.Number.NEUTRAL, "N:n");
        menumElements.put(TagMask.Case.ACCUSATIVE, "C:a");
        menumElements.put(TagMask.Case.DATIVE, "C:d");
        menumElements.put(TagMask.Case.NOMINATIVE, "C:n");
        menumElements.put(TagMask.Case.PREPOSITIVE, "C:g");
        menumElements.put(TagMask.Person.FIRST, "P:1");
        menumElements.put(TagMask.Person.SECOND, "P:2");
        menumElements.put(TagMask.Person.THIRD, "P:3");
        menumElements.put(TagMask.Person.FIRST_THIRD, "P:1_3");
        menumElements.put(TagMask.Tense.PRESENT, "T:p");
        menumElements.put(TagMask.Tense.PRETERITO_IMPERFEITO, "T:pi");
        menumElements.put(TagMask.Tense.PRETERITO_PERFEITO, "T:pp");
        menumElements.put(TagMask.Tense.PRETERITO_MAIS_QUE_PERFEITO, "T:pmp");
        menumElements.put(TagMask.Tense.FUTURE, "T:f");
        menumElements.put(TagMask.Tense.CONDITIONAL, "T:c");
        menumElements.put(TagMask.Mood.IMPERATIVE, "T:i");
        ENUM_MTAG_PARTS = Collections.unmodifiableMap(menumElements);
        Set<Enum<?>> k2 = ENUM_MTAG_PARTS.keySet();
        HashMap stringMElements = new HashMap(60);
        for (Enum<?> tagE : k2) {
            ArrayList values = new ArrayList();
            values.add(tagE);
            stringMElements.put(ENUM_MTAG_PARTS.get(tagE), Collections.unmodifiableList(values));
        }
        ArrayList<TagMask.Gender> _Gn = new ArrayList<TagMask.Gender>();
        _Gn.add(TagMask.Gender.NEUTRAL);
        stringMElements.put("G:2", Collections.unmodifiableList(_Gn));
        stringMElements.put("G:_", Collections.unmodifiableList(_Gn));
        ArrayList<TagMask.Number> _Nn = new ArrayList<TagMask.Number>();
        _Nn.add(TagMask.Number.NEUTRAL);
        stringMElements.put("N:_", Collections.unmodifiableList(_Nn));
        ArrayList<TagMask.Number> _Np = new ArrayList<TagMask.Number>();
        _Np.add(TagMask.Number.PLURAL);
        stringMElements.put("DN:p", Collections.unmodifiableList(_Np));
        ArrayList<TagMask.Number> _Ns = new ArrayList<TagMask.Number>();
        _Ns.add(TagMask.Number.SINGULAR);
        stringMElements.put("DN:s", Collections.unmodifiableList(_Ns));
        ArrayList<TagMask.Person> _P1 = new ArrayList<TagMask.Person>();
        _P1.add(TagMask.Person.FIRST);
        stringMElements.put("AP:1", Collections.unmodifiableList(_P1));
        ArrayList<TagMask.Person> _P2 = new ArrayList<TagMask.Person>();
        _P2.add(TagMask.Person.SECOND);
        stringMElements.put("AP:2", Collections.unmodifiableList(_P2));
        ArrayList<TagMask.Person> _P3 = new ArrayList<TagMask.Person>();
        _P3.add(TagMask.Person.THIRD);
        stringMElements.put("AP:3", Collections.unmodifiableList(_P3));
        stringMElements.put("DP:3", Collections.unmodifiableList(_P3));
        ArrayList<Enum> _Tfc = new ArrayList<Enum>();
        _Tfc.add(TagMask.Tense.FUTURE);
        _Tfc.add(TagMask.Mood.SUBJUNCTIVE);
        stringMElements.put("T:fc", Collections.unmodifiableList(_Tfc));
        ArrayList<Enum> _Tpc = new ArrayList<Enum>();
        _Tpc.add(TagMask.Tense.PRESENT);
        _Tpc.add(TagMask.Mood.SUBJUNCTIVE);
        stringMElements.put("T:pc", Collections.unmodifiableList(_Tpc));
        ArrayList<Enum> _Tpic = new ArrayList<Enum>();
        _Tpic.add(TagMask.Tense.PRETERITO_IMPERFEITO);
        _Tpic.add(TagMask.Mood.SUBJUNCTIVE);
        stringMElements.put("T:pic", Collections.unmodifiableList(_Tpic));
        String[] ind = new String[]{"T:f", "T:p", "T:pi", "T:pmp", "T:pp"};
        MOOD_INDICATIVE = Collections.unmodifiableList(Arrays.asList(ind));
        MTAG_PARTS_ENUM = Collections.unmodifiableMap(stringMElements);
    }
}

