/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities.impl;

import java.io.Serializable;
import java.util.List;
import org.cogroo.entities.Mistake;
import org.cogroo.tools.checker.rules.model.Example;

public class MistakeImpl
implements Mistake,
Serializable {
    private static final long serialVersionUID = 6496020677021379831L;
    private String identifier;
    private String longMessage;
    private String shortMessage;
    private String fullMessage;
    private String[] suggestions;
    private String context;
    private int start;
    private int end;
    private int rulePriority;

    public MistakeImpl(String id, int priority, String message, String shortMessage, String[] suggestions, int start, int end, List<Example> examples, String text) {
        this.rulePriority = priority;
        this.identifier = id;
        this.shortMessage = shortMessage == null || shortMessage.length() == 0 ? (message.length() > 80 ? message.subSequence(0, 80).toString() + " (...)" : message) : shortMessage;
        this.longMessage = message;
        this.suggestions = suggestions;
        this.start = start;
        this.end = end;
        if (examples != null && examples.size() > 0) {
            StringBuffer sb = new StringBuffer(message + "\n");
            sb.append("Exemplos:\n");
            for (Example example : examples) {
                sb.append("  Incorreto: \t" + example.getIncorrect() + "\n");
                sb.append("  Correto:   \t" + example.getCorrect() + "\n");
            }
            this.fullMessage = sb.toString();
        } else {
            this.fullMessage = this.longMessage;
        }
        this.setContextFromText(text);
    }

    @Override
    public String getLongMessage() {
        return this.longMessage;
    }

    @Override
    public String getShortMessage() {
        return this.shortMessage;
    }

    @Override
    public String getFullMessage() {
        return this.fullMessage;
    }

    @Override
    public String[] getSuggestions() {
        return this.suggestions;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("   Rule [").append(this.identifier).append("]\n");
        sb.append("   Mistake span [").append(this.getStart()).append("..").append(this.getEnd()).append("]\n");
        if (this.context != null) {
            sb.append("   Mistake text [").append(this.context.substring(this.getStart(), this.getEnd())).append("]\n");
        }
        sb.append("   Short Message [").append(this.getShortMessage()).append("]\n");
        sb.append("   Long Message  [").append(this.getLongMessage()).append("]\n");
        sb.append("   Full message [").append(this.getFullMessage()).append("]\n");
        sb.append("   Suggestion ");
        if (this.getSuggestions() != null && this.getSuggestions().length > 0) {
            for (String suggestion : this.getSuggestions()) {
                sb.append("[").append(suggestion).append("]");
            }
        } else {
            sb.append("[none]");
        }
        return sb.toString();
    }

    @Override
    public String getRuleIdentifier() {
        return this.identifier;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    private void setContextFromText(String text) {
        if (text != null) {
            this.context = text;
        }
    }

    @Override
    public int getRulePriority() {
        return this.rulePriority;
    }

    @Override
    public void setSuggestions(String[] newSuggestions) {
        this.suggestions = newSuggestions;
    }
}

